<?php

// TOTAL DE CLIENTES DEL VENDEDOR 
$sql = 'SELECT COUNT(DISTINCT s.rowid) AS Total_Clientes
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
WHERE 
    s.entity IN (1)
    AND s.status = 1
    AND u.rowid = ' . $vendedorId;

$resql = $db->query($sql);

if ($resql) {
    $res = $db->fetch_object($resql);
    $clientesVendedor = $res->Total_Clientes;
}

// CLIENTES CON FACTURAS PENDIENTES POR PAGO  
$sql = 'SELECT COUNT(DISTINCT f.rowid) AS Total_Facturas
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_facture AS f ON f.fk_soc = s.rowid 
WHERE 
     f.fk_statut = 1 
    AND f.entity IN (1) 
    AND u.rowid = ' . $vendedorId;

$resql = $db->query($sql);

if ($resql) {
    $res = $db->fetch_object($resql);
    $facturasPendientes = $res->Total_Facturas;
}

// CLIENTES QUE NO SE HAN ACTIVADO POR VENDEDOR   
$sql = 'SELECT COUNT(DISTINCT s.nom) AS ClientesNoactivos
FROM llx_societe AS s
LEFT JOIN llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
WHERE 1 = 1
  AND u.rowid = ' . $vendedorId . '
  AND s.status = 1
  AND s.nom NOT IN (
      SELECT DISTINCT s.nom 
      FROM llx_societe AS s 
      LEFT JOIN llx_facture AS f ON s.rowid = f.fk_soc 
      LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
      LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
      WHERE 1 = 1
        AND f.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
        AND u.rowid = ' . $vendedorId . ')';

$resql = $db->query($sql);

if ($resql) {
    $res = $db->fetch_object($resql);
    $ClientesNoactivos = $res->ClientesNoactivos;
}

// TOTAL VISITAS PROGRAMADAS PARA EL DIA 
$sql = 'SELECT 
    COUNT(*) AS VisitasProgramadas
FROM 
    llx_planificacion_programa AS p 
WHERE 
    p.status = 0 
    AND DATE(p.fecha_visita) = CURDATE()
    AND p.fk_user_creat = ' . $vendedorId;

$resql = $db->query($sql);

if ($resql) {
    $res = $db->fetch_object($resql);
    $VisitasProgramadas = $res->VisitasProgramadas;
}

// CONSULTAS PARA VENTAS Y COBRANZAS
// Ventas por día
$sqlVentas = 'SELECT 
    DATE(f.datef) AS Fecha, 
    SUM(f.total) AS TotalFacturas
FROM 
    llx_facture AS f 
LEFT JOIN 
    llx_societe AS s ON f.fk_soc = s.rowid 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
WHERE 
    f.entity IN (1) 
    AND u.rowid = ' . $vendedorId . ' 
    AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
    AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
    AND f.fk_statut IN (1, 2) 
GROUP BY 
    DATE(f.datef) 
ORDER BY 
    Fecha';

$resqlVentas = $db->query($sqlVentas);
$ventasData = [];
if ($resqlVentas) {
    while ($row = $db->fetch_object($resqlVentas)) {
        $ventasData[] = [
            'Fecha' => $row->Fecha,
            'TotalFacturas' => $row->TotalFacturas
        ];
    }
}

// Cobranza por día
$sqlCobranza = 'SELECT 
    DATE(p.datep) AS fecha,
    SUM(p.amount) AS monto
FROM 
    llx_paiement AS p 
INNER JOIN 
    llx_paiement_facture AS pf ON pf.fk_paiement = p.rowid
INNER JOIN 
    llx_facture AS f ON pf.fk_facture = f.rowid 
INNER JOIN 
    llx_societe AS s ON f.fk_soc = s.rowid 
INNER JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
INNER JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
WHERE 
    f.entity IN (1) 
    AND u.rowid = ' . $vendedorId . ' 
    AND p.datep >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
    AND p.datep < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
GROUP BY 
    DATE(p.datep)
ORDER BY 
    fecha'; 


$resqlCobranza = $db->query($sqlCobranza);
$cobranzaData = [];
if ($resqlCobranza) {
    while ($row = $db->fetch_object($resqlCobranza)) {
        $cobranzaData[] = [
            'fecha' => $row->fecha,
            'monto' => $row->monto
        ];
    }
}

// Convertir datos a JSON
$ventasJSON = json_encode($ventasData);
$cobranzaJSON = json_encode($cobranzaData);

// Consultar Ventas por Volumen
$sqlVolumen = 'SELECT DISTINCT 
    y.label AS Categoria, 
    IF(y.label = "embutidos", 
        SUM(CASE WHEN p.rowid IN ("112", "37") THEN fd.qty ELSE fd.qty * 10 END), 
        SUM(fd.qty)
    ) AS Cantidad 
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_facture AS f ON f.fk_soc = s.rowid 
LEFT JOIN 
    llx_facturedet AS fd ON f.rowid = fd.fk_facture 
LEFT JOIN 
    llx_facture_extrafields AS extra ON f.rowid = extra.fk_object 
LEFT JOIN 
    llx_facturedet_extrafields AS extra2 ON fd.rowid = extra2.fk_object 
LEFT JOIN 
    llx_product AS p ON fd.fk_product = p.rowid 
LEFT JOIN 
    llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object 
LEFT JOIN 
    llx_categorie_product AS cp ON cp.fk_product = p.rowid 
LEFT JOIN 
    llx_categorie AS y ON y.rowid = cp.fk_categorie 
WHERE 
    u.rowid = ' . $vendedorId . ' 
    AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
    AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
GROUP BY 
    Categoria 
ORDER BY 
    Categoria';

$resqlVolumen = $db->query($sqlVolumen);
$ventasVolumenData = [];
if ($resqlVolumen) {
    while ($row = $db->fetch_object($resqlVolumen)) {
        $ventasVolumenData[] = [
            'Categoria' => $row->Categoria,
            'Cantidad' => $row->Cantidad
        ];
    }
}

// Convertir datos a JSON
$ventasVolumenJSON = json_encode($ventasVolumenData);



?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modulo - Vendedores</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .card {
    transition: transform 0.3s ease, box-shadow 0.3s ease; /* Transición suave para el desplazamiento y la sombra */
  }

  .card:hover {
    transform: translateY(-10px); /* Desplazar ligeramente hacia arriba */
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2); /* Sombra más fuerte para resaltar el efecto */
  }
  .icon-link {
    display: inline-flex; /* Alinea el ícono al lado del texto */
    align-items: center; /* Centra verticalmente el ícono */
    margin-left: 10px; /* Espacio entre el texto y el ícono */
    width: 30px; /* Ajusta el tamaño del ícono */
    height: 30px; /* Ajusta el tamaño del ícono */
    border-radius: 50%; /* Hace que el ícono sea redondo */
    background-color: white; /* Cambia a 'orange' para fondo naranja */
    color: white; /* Color del ícono */
    text-align: center; /* Centra el ícono dentro del círculo */
    line-height: 30px; /* Alinea verticalmente el ícono */
    transition: background-color 0.3s; /* Transición suave para el efecto hover */
}

.icon-link:hover {
    background-color: orange; /* Cambia el color al pasar el mouse */
}

    </style>
</head>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<body>
     
    <h3>Bienvenido, <?php echo htmlspecialchars($vendedorNombre); ?>
        
    </h3>
    <h3>Módulo en Actualización, (Datos en Construcción)
        <!-- <a href="DashBoardCliente.php?id=<?php echo urlencode($row->ClienteID); ?>&name=<?php echo urlencode($row->name); ?>" class="link">
            <i class="fas fa-plus"></i> <!-- Ícono de signo de más -->
        </a>
    </h3>
    <hr>


    <div class="row" style="margin-top: 25px;">
        <div class="col-3">
          <!-- Primer carta: Clientes con Saldo Vencido -->
          <div class="card mb-4 border-0 rounded-3 shadow">
            <div class="row g-0">
              <div class="col-md-4 d-flex justify-content-center align-items-center">
                
                <a class="link-dark" href="Clientesaldovencido.php?vendedorId=<?php echo urlencode($vendedorId); ?>">
    <i class="bi bi-person-fill-exclamation" style="font-size: 2.5rem;"></i>
</a>
              </div>
              <div class="col-md-8">
                <div class="card-body">
                  <p><small class="text-muted">Cuentas por Cobrar</small></p>
                  <h5 class="card-title" style="font-size: 1.5rem;"><?php echo htmlspecialchars($facturasPendientes); ?></h5>
                </div>
              </div>
            </div>
          </div>
      
          <!-- Segunda carta: Clientes Pendientes por Visitar -->
          <div class="card mb-4 border-0 rounded-3 shadow">
            <div class="row g-0">
              <div class="col-md-4 d-flex justify-content-center align-items-center">
                <a class="link-dark"><i class="bi bi-person-lines-fill" style="font-size: 2.5rem;"></i></a>
              </div>
              <div class="col-md-8">
                <div class="card-body">
                  <p><small class="text-muted">Clientes por Visitar</small></p>
                  <h5 class="card-title" style="font-size: 1.5rem;"><?php echo htmlspecialchars($VisitasProgramadas); ?></h5>
                </div>
              </div>
            </div>
          </div>
        </div>
      
        <div class="col-3">
          <!-- Tercer carta: Clientes  -->
          <div class="card mb-4 border-0 rounded-3 shadow">
            <div class="row g-0">
              <div class="col-md-4 d-flex justify-content-center align-items-center">
                <i class="bi bi-people-fill" style="font-size: 2.5rem;"></i>
              </div>
              <div class="col-md-8">
                <div class="card-body">
                  <p><small class="text-muted">Total Clientes</small></p>
                  <h5 class="card-title" style="font-size: 1.5rem;"><?php echo htmlspecialchars($clientesVendedor); ?></h5>
                </div>
              </div>
            </div>
          </div>
      
          <!-- Cuarta carta: Clientes sin Activar -->
          <div class="card mb-4 border-0 rounded-3 shadow ">
            <div class="row g-0">
              <div class="col-md-4 d-flex justify-content-center align-items-center">
                <a class="link-dark" href="Clientes_inactivos.php?vendedorId=<?php echo urlencode($vendedorId); ?>"><i class="bi bi-person-x-fill" style="font-size: 2.5rem;"></i></a>
              </div>
              <div class="col-md-8">
                <div class="card-body">
                  <p><small class="text-muted">Clientes sin Activar</small></p>
                  <h5 class="card-title" style="font-size: 1.5rem;"><?php echo htmlspecialchars($ClientesNoactivos); ?></h5>
                </div>
              </div>
            </div>
          </div>
        </div>
     
        <?php
        // Ejecutar la consulta
        $sql = "SELECT 
    p.ref AS Ref, 
    p.fecha_visita AS Fecha, 
    CASE 
        WHEN p.fk_soc IS NULL OR p.fk_soc = '' THEN p.potencial 
        ELSE s.nom 
    END AS Cliente, 
    s.phone AS Tlf, 
    s.rowid AS ClienteID
FROM 
    llx_planificacion_programa AS p
LEFT JOIN 
    llx_societe AS s ON p.fk_soc = s.rowid
WHERE 
    p.status = 0 
    AND DATE(p.fecha_visita) = CURDATE() 
    AND p.fk_user_creat = " . $vendedorId;

        $resql = $db->query($sql);

        if ($resql) {
    // Iniciar el contenedor de la lista
    echo '<div class="col-6">
            <div class="card border-0 rounded-2 shadow">
                <div class="card-body">
                    <h4>Planificación del día
                        <a href="dashboard_planicacionpedro.php?id=' . urlencode($vendedorId) . '" class="link icon-link">
                            <i class="fas fa-plus"></i> <!-- Ícono de signo de más -->
                        </a>
                    </h4>

                    <div class="overflow-auto" style="max-height: 160px;">
                        <ol class="list-group list-group-numbered">';


            // Recorrer los resultados y generar los elementos de la lista
            while ($row = $db->fetch_object($resql)) {
                echo '<li class="list-group-item d-flex justify-content-between align-items-start">
                        <div class="ms-2 me-auto">
                             <a href="DashBoardCliente.php?id=' . urlencode($row->ClienteID) . '" class="link-dark link-underline-opacity-0 link-underline-opacity-100-hover">
                        <div class="fw-bold">' . htmlspecialchars($row->Cliente) . '</div>
                    </a>
                        <span class="badge text-bg-light rounded-pill">' . htmlspecialchars($row->Ref) . ' |</span>
                        <span class="badge text-bg-light rounded-pill">' . htmlspecialchars($row->Tlf) . '</span>
                      </li>';
            }

            // Cerrar la lista y el contenedor
            echo '        </ol>
                        </div>
                    </div>
                </div>
            </div>';
        } else {
            echo "Error en la consulta: " . $db->error; // Muestra un error si ocurre
        }
        ?>

    </div>
    
    <div class="row">
        <div class="col-8">
            <div class="card border-0 rounded-3 shadow">
                <h4><i class="bi bi-currency-dollar"></i>  Ventas y Cobranzas</h4>
                <canvas id="ventasCobrosChart"></canvas>
            
                <script>
                    const ctx = document.getElementById('ventasCobrosChart').getContext('2d');

                    // Datos de ventas y cobros en formato JSON
                    const ventasData = <?php echo $ventasJSON; ?>;
                    const cobranzaData = <?php echo $cobranzaJSON; ?>;

                    // Preparar las etiquetas y los datos para el gráfico
                    const dias = ['Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'];
                    const ventas = Array(7).fill(0);
                    const cobranzas = Array(7).fill(0);

                    // Mapear las ventas
                    ventasData.forEach(item => {
                        const diaIndex = new Date(item.Fecha).getDay(); // Obtener el índice del día (0 = Domingo)
                        ventas[diaIndex] = item.TotalFacturas; // Asignar el total de facturas al día correspondiente
                    });

                    // Mapear las cobranzas
                    cobranzaData.forEach(item => {
                        const diaIndex = new Date(item.fecha).getDay(); // Obtener el índice del día
                        cobranzas[diaIndex] = item.monto; // Asignar el monto al día correspondiente
                    });

                    const ventasCobrosData = {
                        labels: dias,
                        datasets: [{
                            label: 'Venta',
                            data: ventas, // Usar datos de ventas
                            backgroundColor: 'rgb(169, 169, 169)',
                            borderRadius: 8,
                            borderWidth: 0,
                        }, {
                            label: 'Cobranza',
                            data: cobranzas, // Usar datos de cobranza
                            backgroundColor: 'rgb(255, 140, 0)',
                            borderRadius: 8,
                            borderWidth: 0,
                        }]
                    };

                    const config = {
                        type: 'bar',
                        data: ventasCobrosData,
                        options: {
                            responsive: true,
                            plugins: {
                                legend: {
                                    position: 'top',
                                },
                                tooltip: {
                                    enabled: true,
                                }
                            },
                            scales: {
                                y: {
                                    beginAtZero: true,
                                    title: {
                                        display: true,
                                        grid: {
                                            display: false,
                                        },
                                    },
                                },
                                x: {
                                    title: {
                                        display: true,
                                    },
                                    grid: {
                                        display: false,
                                    },
                                    ticks: {
                                        autoSkip: false
                                    },
                                }
                            },
                            barPercentage: 0.4,
                            categoryPercentage: 0.5,
                        }
                    };

                    const ventasCobrosChart = new Chart(ctx, config);
                </script>
            </div>
        </div>
       <div class="col-4">
    <div class="card mb-4 border-0 rounded-3 shadow">
        <div class="card-body">
            <h5>Ventas por Volumen</h5>
            <canvas id="ventasVolumenChart"></canvas>
            <script>
                const ctx2 = document.getElementById('ventasVolumenChart').getContext('2d');

                // Datos de ventas por volumen en formato JSON
                const volumenData = <?php echo $ventasVolumenJSON; ?>;

                // Preparar las etiquetas y los datos para el gráfico
                const categorias = volumenData.map(item => item.Categoria);
                const cantidades = volumenData.map(item => item.Cantidad);

                const dataVolumen = {
                    labels: categorias,
                    datasets: [{
                        label: 'Ventas por Volumen',
                        data: cantidades,
                        backgroundColor: ['#FF8C00', '#FF6F61', '#FF3B3F', '#FF5745', '#FF5733'],
                        borderWidth: 1,
                    }]
                };

                const configVolumen = {
                    type: 'doughnut', // Cambiado de 'bar' a 'doughnut'
                    data: dataVolumen,
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'top',
                            },
                            tooltip: {
                                enabled: true,
                            }
                        },
                        cutout: '60%', // Para hacer un gráfico de anillo
                    }
                };

                const ventasVolumenChart = new Chart(ctx2, configVolumen);
            </script>                    
        </div>
    </div>
</div>



</body>
</html>
