<?php
require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';

$langs->load('admin');
$langs->load('bills');

if (GETPOST('export_csv', 'alpha')) {
    // Obtener los datos enviados
    $data = GETPOST('data', 'array');

    // Decodificar los datos JSON
    $products = json_decode($data, true);

    // Configuracin del encabezado para descargar el archivo CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="stock_data.csv"');

    // Abrir el flujo de salida
    $output = fopen('php://output', 'w');

    // Escribir encabezados de columna
    fputcsv($output, ['Referencia', 'Etiqueta', 'Stock']);

    // Escribir los datos
    foreach ($products as $product) {
        fputcsv($output, [$product['ref'], $product['label'], $product['stock']]);
    }

    fclose($output);
    exit;
}
?>
