<?php
// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME']; $tmp2 = realpath(__FILE__); $i = strlen($tmp) - 1; $j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) { $i--; $j--; }
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1))."/main.inc.php")) $res = @include substr($tmp, 0, ($i + 1))."/main.inc.php";
if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php")) $res = @include dirname(substr($tmp, 0, ($i + 1)))."/main.inc.php";
// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) $res = @include "../main.inc.php";
if (!$res && file_exists("../../main.inc.php")) $res = @include "../../main.inc.php";
if (!$res && file_exists("../../../main.inc.php")) $res = @include "../../../main.inc.php";
if (!$res) die("Include of main fails");

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formcompany.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';

// load planificacion libraries
require_once __DIR__.'/class/programa.class.php';

// for other modules
//dol_include_once('/othermodule/class/otherobject.class.php');

// Load translation files required by the page
$langs->loadLangs(array("planificacion@planificacion", "other"));

$action     = GETPOST('action', 'aZ09') ?GETPOST('action', 'aZ09') : 'view'; // The action 'add', 'create', 'edit', 'update', 'view', ...
$massaction = GETPOST('massaction', 'alpha'); // The bulk action (combo box choice into lists)
$show_files = GETPOST('show_files', 'int'); // Show files area generated by bulk actions ?
$confirm    = GETPOST('confirm', 'alpha'); // Result of a confirmation
$cancel     = GETPOST('cancel', 'alpha'); // We click on a Cancel button
$toselect   = GETPOST('toselect', 'array'); // Array of ids of elements selected into a list
$contextpage = GETPOST('contextpage', 'aZ') ? GETPOST('contextpage', 'aZ') : 'programalist'; // To manage different context of search
$backtopage = GETPOST('backtopage', 'alpha'); // Go back to a dedicated page
$optioncss  = GETPOST('optioncss', 'aZ'); // Option for the css output (always '' except when 'print')
$id = GETPOST('id', 'int');

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes con Saldo Vencido</title>
    <link rel="stylesheet" href="style.css">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome para íconos -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <!-- Estilos personalizados -->
    <style>
        h1 {
            font-size: 40px;
            color: #333;
            margin-bottom: 40px;
        }

        .card {
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .table {
            border-radius: 8px;
        }

        .table th,
        .table td {
            vertical-align: middle;
        }

        .table thead {
            background-color: #fff;
            color: #333;
        }

        .table tbody tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1 class="text-left">Clientes con Saldo Vencido</h1>
        <hr>

        <!-- Card para la tabla -->
        <div class="card mb-4 border-0 rounded-2 shadow fade-in-up">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Número</th>
                                <th>Nro Factura</th>
                                <th>CLIENTE</th>
                                <th>FECHA DE FACTURACIÓN</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // CLIENTES CON DEUDAS DEL VENDEDOR 
                            $sql = 'SELECT DISTINCT f.ref as nro_factura, s.nom as nombre_cliente, f.datef as fecha_facturacion
                            FROM 
                                llx_societe AS s 
                            LEFT JOIN 
                                llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                            LEFT JOIN 
                                llx_user AS u ON sc.fk_user = u.rowid 
                            LEFT JOIN 
                                llx_facture AS f ON f.fk_soc = s.rowid 
                            WHERE 
                                 f.fk_statut = 1 
                                AND f.entity IN (1) 
                                AND u.rowid = ' . (int)$vendedorId; // Asegúrate de castigar a int para evitar inyección SQL

                            $resql = $db->query($sql);

                            if ($resql) {
                                $index = 1; // Para numerar los clientes
                                while ($res = $db->fetch_object($resql)) {
                                    echo "<tr>";
                                    echo "<td>" . htmlspecialchars($index++) . "</td>";
                                    echo "<td>" . htmlspecialchars($res->nro_factura) . "</td>";
                                    echo "<td>" . htmlspecialchars($res->nombre_cliente) . "</td>";
                                    echo "<td>" . htmlspecialchars($res->fecha_facturacion) . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='6'>Error en la consulta: " . htmlspecialchars($db->error) . "</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
