<?php
setlocale(LC_TIME, 'es_ES.UTF-8');
// Conexión a la base de datos
$host = 'localhost';
$db = 'aliment5_doli2';
$usuario = 'aliment5_root';
$pass = 'pluton007$';

$conn = new mysqli($host, $usuario, $pass, $db);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Inicializar variables
$mensaje = '';
$resultado = null;

$vendedorId = isset($_GET['id']) ? intval($_GET['id']) : null;

// Manejo de operaciones CRUD
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create'])) {
        // Crear registro
        $ref = $_POST['ref'];
        $fk_soc = $_POST['fk_soc'];
        $fecha_visita = $_POST['fecha_visita'];
        $comentario = $_POST['comentario'];
        $status = $_POST['status'];
        $user = $vendedorId;

        // Variables para cliente potencial
        //$telefono = $direccion = $contacto = null;
        if (isset($_POST['cliente_potencial'])) {
            $potencial = $_POST['potencial'];
            $telefono = $_POST['telefono'];
            $direccion = $_POST['direccion'];
            $contacto = $_POST['contacto'];
        }

        // Verificar si ya existe un registro con el mismo ID
        $stmt = $conn->prepare("SELECT COUNT(*) FROM llx_planificacion_programa WHERE rowid = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count > 0) {
            $mensaje = "El registro ya existe.";
        } else {
            // Preparar la consulta para insertar
            if (isset($_POST['cliente_potencial'])) {
                // Incluir los campos adicionales en la consulta
               $stmt = $conn->prepare("INSERT INTO llx_planificacion_programa (ref, fecha_visita, comentario, status, potencial, telefono, direccion, contacto, date_creation, fk_user_creat) VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
                $stmt->bind_param("sssssssss", $ref, $fecha_visita, $comentario, $status, $potencial, $telefono, $direccion, $contacto, $user);
            } else {
                // Consulta sin los campos adicionales
               $stmt = $conn->prepare("INSERT INTO llx_planificacion_programa (ref, fk_soc, fecha_visita, comentario, status, date_creation, fk_user_creat) VALUES (?, ?, ?, ?, ?, NOW(), ?)");
            $stmt->bind_param("ssssss", $ref, $fk_soc, $fecha_visita, $comentario, $status,    $user);
            }

            // Ejecutar la inserción
            if ($stmt->execute()) {
                $mensaje = "Registro creado exitosamente.";
            } else {
                $mensaje = "Error al crear el registro: " . $stmt->error;
            }
            $stmt->close();
        }
    }
        
} if (isset($_POST['update'])) {
    $id = $_POST['id']; // Obtener el ID del registro
    $comentario = $_POST['comentario'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("UPDATE llx_planificacion_programa SET comentario=?, status=? WHERE rowid=?");
    $stmt->bind_param("ssi", $comentario, $status, $id); // Asegúrate de incluir el ID aquí
    if ($stmt->execute()) {
        $mensaje = "Registro actualizado exitosamente.";
       
    } else {
        $mensaje = "Error al actualizar el registro: " . $stmt->error;
       
    }
    $stmt->close();


    } elseif (isset($_POST['delete'])) {
        // Eliminar registro
        $id = $_POST['id'];
        $stmt = $conn->prepare("DELETE FROM llx_planificacion_programa WHERE rowid=?");
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $mensaje = "Registro eliminado exitosamente.";
        } else {
            $mensaje = "Error al eliminar el registro: " . $stmt->error;
        }
        $stmt->close();
    }


// Filtrar registros
$filtroFechaInicio = '';
$filtroFechaFin = '';
if (isset($_GET['filtro_fecha_inicio']) && isset($_GET['filtro_fecha_fin'])) {
    $filtroFechaInicio = $_GET['filtro_fecha_inicio'];
    $filtroFechaFin = $_GET['filtro_fecha_fin'];
}

// Obtener registros de clientes
$clientes = $conn->query("
    SELECT s.rowid as rowid, s.nom as nom
    FROM llx_societe AS s 
    LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
    LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
    WHERE s.entity IN (1)
    AND s.status = 1
    AND u.rowid = '$vendedorId'
    ORDER BY s.nom ASC
");

// Consulta SQL base
$sql = "
SELECT p.rowid, p.ref, p.fk_soc, p.fecha_visita, p.comentario, p.status, p.date_creation, p.fk_user_creat, s.nom AS cliente, p.potencial 
FROM llx_planificacion_programa p 
LEFT JOIN llx_societe s ON p.fk_soc = s.rowid 
WHERE p.fk_user_creat = ?";

// Si no hay filtros, mostrar la semana actual
if (empty($filtroFechaInicio) && empty($filtroFechaFin)) {
    $sql .= " AND p.fecha_visita >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY
              AND p.fecha_visita < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY";
} else {
    // Agregar filtros de fecha si están presentes
    if (!empty($filtroFechaInicio)) {
        $sql .= " AND p.fecha_visita >= ?";
    }
    if (!empty($filtroFechaFin)) {
        $sql .= " AND p.fecha_visita <= ?";
    }
}

$sql .= " ORDER BY p.fecha_visita, p.rowid;";

// Preparar la declaración
$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Error en la preparación de la declaración: " . $conn->error);
}

// Enlazar parámetros
$params = [$vendedorId]; // Agregar el vendedorId primero
$types = 'i'; // Tipo de dato para el vendedorId

if (!empty($filtroFechaInicio)) {
    $params[] = $filtroFechaInicio;
    $types .= 's'; // Tipo de dato para string
}
if (!empty($filtroFechaFin)) {
    $params[] = $filtroFechaFin;
    $types .= 's'; // Tipo de dato para string
}

// Enlazar los parámetros
$stmt->bind_param($types, ...$params);

// Ejecutar la consulta
$stmt->execute();
$resultado = [];

// Asegúrate de que el número de variables aquí coincida con el número de columnas seleccionadas
$stmt->bind_result($rowid, $ref, $fk_soc, $fecha_visita, $comentario, $status, $date_creation, $fk_user_creat, $cliente, $potencial);

while ($stmt->fetch()) {
    $resultado[] = [
        'rowid' => $rowid,
        'ref' => $ref,
        'fk_soc' => $fk_soc,
        'fecha_visita' => $fecha_visita,
        'comentario' => $comentario,
        'fk_user_creat' => $fk_user_creat,
        'date_creation' => $date_creation,
        'status' => $status,
        'cliente' => $cliente,
        'potencial' => $potencial,
    ];
}

// Cerrar conexión
$stmt->close(); // Cierra la declaración
$conn->close(); // Cierra la conexión
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    
    
    
    <title>CRUD Planificación Programa</title>
  
     <div class="container mt-5">
        <a href="planificacionindex.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Regresar
        </a>
    </div>
    
    <style>
        body {
            font-size: 14px; /* Tamaño de fuente global */
        }
        .header {
            display: flex;
            align-items: center; /* Centrar verticalmente */
            background-color: #007bff; /* Fondo azul */
            color: white; /* Texto blanco */
            padding: 10px; /* Espaciado interno */
            border-radius: 10px; /* Bordes redondeados */
            margin-bottom: 20px; /* Espacio inferior */
        }
        .header img {
            width: 200px; /* Ancho del logotipo */
            height: auto; /* Mantener proporciones */
            margin-right: 15px; /* Espacio entre el logo y el título */
        }
        .card {
            background-color: #ffffff; /* Fondo blanco para la tarjeta */
            border-radius: 10px; /* Bordes redondeados */
            padding: 4px; /* Espaciado interno reducido */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
            margin-bottom: 10px; /* Espacio entre tarjetas */
            width: fit-content; /* Ancho según su contenido */
        }
        .form-control {
            border-radius: 5px; /* Bordes redondeados en los campos */
            font-size: 1rem; /* Tamaño de fuente para los campos del formulario */
        }
        .alert {
            margin-top: 20px; /* Espacio superior para el mensaje */
        }
        .status-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 5px;
        }
        .status-0 {
            background-color: yellow;
        }
        .status-1 {
            background-color: green;
        }
        .dia-semana {
            display: flex; /* Usar flexbox para alinear los días en una fila */
            flex-wrap: wrap; /* Permitir que los elementos se envuelvan en caso de que no haya espacio */
            justify-content: flex-start; /* Alinear a la izquierda */
        }
        .dia {
            flex: 1 1 30%; /* Cada día ocupa un 30% del ancho disponible, ajusta según necesites */
            margin: 5px; /* Espacio reducido entre días */
        }
        .icono-boton {
            width: 30px; /* Cambia el tamaño según sea necesario */
            height: auto; /* Mantiene la proporción */
        }
        .btn {
            border: none; /* Sin borde */
            padding: 0; /* Sin padding */
        }
        .btn i {
            font-size: 24px; /* Cambia el tamaño del ícono */
        }
        
        
    .modify-form {
        border: none; /* Sin marco */
        padding: 10px; /* Espaciado interno */
        background-color: #f9f9f9; /* Fondo claro */
        border-radius: 5px; /* Bordes redondeados */
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Sombra suave */
        margin-bottom: 10px; /* Espacio inferior */
    }
    .modify-form input,
    .modify-form select {
        font-size: 12px; /* Tamaño de fuente más pequeño */
    }
    .status-label {
        font-weight: bold; /* Negrita para el estado */
    }
    .status-0 {
        color: green; /* Color verde para 'Programada' */
    }
    .status-1 {
        color: yellow; /* Color amarillo para 'Ejecutada' */
    }

        
    </style>
</head>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<body>
<div class="container mt-5">
    <div>
        <h2 class="m-0"><i class="bi bi-calendar4-week"></i>  Área de Planificación </h2>
        <hr>
    </div>

    <?php if ($mensaje): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($mensaje); ?></div>
    <?php endif; ?>
<div class="card" style="width: 80rem;">
    <div class="card-body">
        <form method="GET" class="mb-4">
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($vendedorId); ?>"> <!-- Campo oculto para el vendedorId -->
            <div class="row">
                <div class="col-md-3">
                    <input type="date" name="filtro_fecha_inicio" class="form-control" placeholder="Fecha Inicio" value="<?php echo htmlspecialchars($filtroFechaInicio); ?>">
                </div>
                <div class="col-md-3">
                    <input type="date" name="filtro_fecha_fin" class="form-control" placeholder="Fecha Fin" value="<?php echo htmlspecialchars($filtroFechaFin); ?>">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-outline-dark" style="padding:0px 15px;">
                        <i class="bi bi-search"></i>
                    </button>
                    <a href="dashboard_planicacionpedro.php?id=<?php echo urlencode($vendedorId); ?>" class="btn btn-outline-warning" style="padding:0px 15px;">
                        <i class="bi bi-filter"></i> Quitar Filtro
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="container mt-5">
   <button id="toggleForm" class="btn btn-light btn-lg" data-toggle="modal" data-target="#visitaModal" style="padding: 15px 30px;">
    <i class="bi bi-calendar-plus" style="padding:0px 30px;">  Nueva Planificación</i>
   </button>
    <hr>
    <!-- Modal -->
    <div class="modal fade" id="visitaModal" tabindex="-1" aria-labelledby="visitaModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="visitaModalLabel">Crear Visita</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span>&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" id="newRecordForm">
                        <div class="row justify-content-center">
                            <div class="col-md-6 mb-3">
                                <label for="ref">Referencia</label>
                                <input type="text" name="ref" class="form-control" placeholder="Referencia" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="fk_soc">Cliente</label>
                                <select name="fk_soc" class="form-control" >
                                    <option value="">Seleccionar Cliente</option>
                                    <?php while ($cliente = $clientes->fetch_assoc()): ?>
                                        <option value="<?php echo $cliente['rowid']; ?>"><?php echo htmlspecialchars($cliente['nom']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                        <div class="row justify-content-center">
                            <div class="col-md-6 mb-3">
                                <label for="fecha_visita">Fecha Visita</label>
                                <input type="date" name="fecha_visita" class="form-control" placeholder="Fecha Visita" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="comentario">Comentario</label>
                                <input type="text" name="comentario" class="form-control" placeholder="Comentario">
                            </div>
                        </div>
                        <div class="row justify-content-center">
                            <div class="col-md-6 mb-3">
                                <label for="status">Estado</label>
                                <select name="status" class="form-control" required>
                                    <option value="0">Programada</option>
                                    <option value="1">Realizada</option>
                                </select>
                            </div>

                            <div class="col-md-12 mb-3 text-center">
                                <label>
                                    <input type="checkbox" name="cliente_potencial" id="cliente_potencial" value="1"> Cliente Potencial
                                </label>
                            </div>
                            <div id="campos_adicionales" style="display:none;" class="col-md-12">
                                <div class="row justify-content-center">
                                    <div class="col-md-4 mb-3">
                                        <label for="potencial">Potencial</label>
                                        <input type="text" name="potencial" class="form-control" placeholder="Potencial">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="telefono">Teléfono</label>
                                        <input type="text" name="telefono" class="form-control" placeholder="Teléfono">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="direccion">Dirección</label>
                                        <input type="text" name="direccion" class="form-control" placeholder="Dirección">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="contacto">Contacto</label>
                                        <input type="text" name="contacto" class="form-control" placeholder="Contacto">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" name="create" class="btn btn-success" style="padding:5px 10px;"> 
                                <i class="bi bi-calendar-check"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container-fluid mt-5">
    <div class="row dia-semana">
    <?php if ($resultado): 
        $datosPorDia = [];
        foreach ($resultado as $fila) {
            $fecha = date('Y-m-d', strtotime($fila['fecha_visita']));
            if (!isset($datosPorDia[$fecha])) {
                $datosPorDia[$fecha] = [];
            }
            $datosPorDia[$fecha][] = $fila;
        }

        foreach ($datosPorDia as $dia => $datos): ?>
            <div class="col-12 dia">
                <div class="card">
                    <div class="card-body">
                        <div class="overflow-auto" style="max-height: 215px;">
                          <h5 class="card-title"><?php echo strftime('%A, %d %B %Y', strtotime($dia)); ?></h5> <!-- Muestra el día en español -->
                            <?php foreach ($datos as $fila): ?>
                                
                                     <!-- <strong>Planificación ID:</strong> -->
                                             <!-- <?php echo htmlspecialchars($fila['rowid']) . ' '; ?>  -->
                                    
                              
                                <p><strong>Referencia:</strong> <?php echo htmlspecialchars($fila['ref']); ?> <span class="status-indicator <?php echo $fila['status'] == 0 ? 'status-0' : 'status-1'; ?>"></span></p>
                                <p><strong>Cliente:</strong> <?php echo htmlspecialchars($fila['cliente']); ?>  <?php echo htmlspecialchars($fila['potencial']); ?> </p>
                                <!-- <p><strong>Comentario:</strong> <?php echo htmlspecialchars($fila['comentario']); ?></p> -->
                               
                               <form method="POST" class="modify-form">
    <input type="hidden" name="id" value="<?php echo htmlspecialchars($fila['rowid']); ?>"> <!-- ID oculto -->
    <input type="text" name="comentario" value="<?php echo htmlspecialchars($fila['comentario']); ?>" class="form-control mb-2" required> <!-- Comentario editable -->
    
    <!-- <label class="status-label <?php echo $fila['status'] == 0 ? 'status-0' : 'status-1'; ?>">
        Estado: 
        <?php echo $fila['status'] == 0 ? 'Programada' : 'Ejecutada'; ?>
    </label>    -->
    
    <select name="status" class="form-control mb-2" required>
        <option value="0" <?php echo $fila['status'] == 0 ? 'selected' : ''; ?>>Programada</option>
        <option value="1" <?php echo $fila['status'] == 1 ? 'selected' : ''; ?>>Realizada</option>
    </select>
    
    <button type="submit" name="update" class="btn btn-success btn-sm">
        <i class="fas fa-check"></i> <!-- Ícono de actualizar -->
    </button>
    <!-- <button type="button" class="btn btn-danger btn-sm" onclick="cancelEdit(this)">
        <i class="fas fa-times"></i> <!-- Ícono de cancelar
    </button>   -->
    <button type="submit" name="delete" class="btn btn-warning btn-sm">
        <i class="fas fa-trash"></i> <!-- Ícono de eliminar -->
    </button>
</form>


                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; endif; ?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        function enableFields(button) {
            const form = button.closest('form');
            const inputs = form.querySelectorAll('input[type="hidden"]');
            inputs.forEach(input => {
                const inputField = document.createElement('input');
                inputField.type = 'text';
                inputField.name = input.name;
                inputField.value = input.value;
                inputField.className = 'form-control mb-2';
                form.insertBefore(inputField, button);
                input.remove(); // Eliminar el campo oculto
            });
            button.style.display = 'none'; // Ocultar botón de modificar
            form.querySelector('button[name="update"]').style.display = 'inline'; // Mostrar botón de actualización
            form.querySelector('button[type="button"].btn-secondary').style.display = 'inline'; // Mostrar botón de cancelar
        }

        function cancelEdit(button) {
            const form = button.closest('form');
            const inputs = form.querySelectorAll('input[type="text"]');
            inputs.forEach(input => {
                const hiddenInput = document.createElement('input');
                hiddenInput.type = 'hidden';
                hiddenInput.name = input.name;
                hiddenInput.value = input.value;
                form.insertBefore(hiddenInput, input);
                input.remove(); // Eliminar el campo editable
            });
            button.style.display = 'none'; // Ocultar botón de cancelar
            form.querySelector('button[type="button"]').style.display = 'inline'; // Mostrar botón de modificar
        }

        // Mostrar/Ocultar formulario de nuevo registro
        document.getElementById('toggleForm').addEventListener('click', function() {
            const formContainer = document.getElementById('formContainer');
            formContainer.style.display = formContainer.style.display === 'none' ? 'block' : 'none';
        });
    // Mostrar/ocultar campos adicionales según el checkbox
    document.querySelector('input[name="cliente_potencial"]').addEventListener('change', function() {
        document.getElementById('campos_adicionales').style.display = this.checked ? 'block' : 'none';
    });
    </script>
    
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
</body>
</html>

