<?php
// Conexión a la base de datos
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

// Verifica si la conexión fue exitosa
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

// Consulta para obtener todos los vendedores
$query = $mysqli->query("SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre 
                          FROM llx_user as u 
                          LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user
                          WHERE u.statut = 1
                          AND u.firstname != ''
                          AND u.rowid NOT IN (50, 58)  -- Cambiado a NOT IN
                          AND us.fk_usergroup = 1");

// Inicializa un array para almacenar los datos de los vendedores
$vendedoresData = [];

// Verifica si la consulta devolvió resultados
if ($query->num_rows > 0) {
    while ($valores = mysqli_fetch_array($query)) {
        // ID del vendedor actual
        $vendedorId = $valores['rowid'];

        // TOTAL DE CLIENTES DEL VENDEDOR 
        $sql = 'SELECT COUNT(DISTINCT s.rowid) AS Total_Clientes
                FROM llx_societe AS s 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                WHERE s.entity IN (1) AND s.status = 1 AND u.rowid = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $clientesVendedor = $resql ? $resql->fetch_object()->Total_Clientes : 0;

        // CLIENTES CON FACTURAS PENDIENTES POR PAGO  
        $sql = 'SELECT COUNT(DISTINCT f.rowid) AS Total_Facturas
                FROM llx_societe AS s 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                LEFT JOIN llx_facture AS f ON f.fk_soc = s.rowid 
                WHERE f.fk_statut = 1 AND f.entity IN (1) AND u.rowid = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $facturasPendientes = $resql ? $resql->fetch_object()->Total_Facturas : 0;

        // CLIENTES QUE NO SE HAN ACTIVADO POR VENDEDOR   
        $sql = 'SELECT COUNT(DISTINCT s.nom) AS ClientesNoactivos
                FROM llx_societe AS s
                LEFT JOIN llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                WHERE u.rowid = ' . $vendedorId . ' AND s.status = 1
                AND s.nom NOT IN (
                    SELECT DISTINCT s.nom 
                    FROM llx_societe AS s 
                    LEFT JOIN llx_facture AS f ON s.rowid = f.fk_soc 
                    LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                    LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                    WHERE f.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
                    AND u.rowid = ' . $vendedorId . ')';

        $resql = $mysqli->query($sql);
        $ClientesNoactivos = $resql ? $resql->fetch_object()->ClientesNoactivos : 0;

        // TOTAL VISITAS PROGRAMADAS PARA EL DIA 
        $sql = 'SELECT COUNT(*) AS VisitasProgramadas
                FROM llx_planificacion_programa AS p 
                WHERE p.status = 0 
                AND DATE(p.fecha_visita) = CURDATE()
                AND p.fk_user_creat = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $VisitasProgramadas = $resql ? $resql->fetch_object()->VisitasProgramadas : 0;

        // Almacena los datos del vendedor en el array
        $vendedoresData[] = [
            'rowid' => $vendedorId,
            'nombre' => $valores['nombre'],
            'clientes' => $clientesVendedor,
            'facturas' => $facturasPendientes,
            'noactivos' => $ClientesNoactivos,
            'visitas' => $VisitasProgramadas
        ];
    }
}

// Consultar Ventas por Volumen
$ventasVolumenData = [];
foreach ($vendedoresData as $vendedor) {
    $vendedorId = $vendedor['rowid']; // Asumiendo que el array tiene la clave 'rowid'
    
    // Mantener la conexión abierta
    $sqlVolumen = 'SELECT DISTINCT 
        y.label AS Categoria, 
        IF(y.label = "embutidos", 
            SUM(CASE WHEN p.rowid IN ("112", "37", "137", "120", "142") THEN fd.qty ELSE fd.qty * 10 END), 
            SUM(fd.qty)
        ) AS Cantidad 
    FROM 
        llx_societe AS s 
    LEFT JOIN 
        llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
    LEFT JOIN 
        llx_user AS u ON sc.fk_user = u.rowid 
    LEFT JOIN 
        llx_facture AS f ON f.fk_soc = s.rowid 
    LEFT JOIN 
        llx_facturedet AS fd ON f.rowid = fd.fk_facture 
    LEFT JOIN 
        llx_facture_extrafields AS extra ON f.rowid = extra.fk_object 
    LEFT JOIN 
        llx_facturedet_extrafields AS extra2 ON fd.rowid = extra2.fk_object 
    LEFT JOIN 
        llx_product AS p ON fd.fk_product = p.rowid 
    LEFT JOIN 
        llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object 
    LEFT JOIN 
        llx_categorie_product AS cp ON cp.fk_product = p.rowid 
    LEFT JOIN 
        llx_categorie AS y ON y.rowid = cp.fk_categorie 
    WHERE 
        u.rowid = ' . $vendedorId . ' 
        AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
        AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
    GROUP BY 
        Categoria 
    ORDER BY 
        Categoria';

    $resqlVolumen = $mysqli->query($sqlVolumen);
    if ($resqlVolumen) {
        while ($row = $resqlVolumen->fetch_object()) {
            // Asegúrate de inicializar la categoría si no existe
            if (!isset($ventasVolumenData[$vendedorId])) {
                $ventasVolumenData[$vendedorId] = [];
            }
            $ventasVolumenData[$vendedorId][$row->Categoria] = $row->Cantidad;
        }
    }
}

// Consultar Ventas y Cobranzas por el Día Actual
$ventasCobranzasData = [];
foreach ($vendedoresData as $vendedor) {
    $vendedorId = $vendedor['rowid'];
    
    $sqlCobranzas = 'SELECT 
        SUM(fd.qty * p.price) AS Total_Ventas,
        SUM(CASE WHEN f.fk_statut = 1 THEN fd.qty * p.price ELSE 0 END) AS Total_Cobranzas
    FROM 
        llx_facture AS f 
    LEFT JOIN 
        llx_facturedet AS fd ON f.rowid = fd.fk_facture 
    LEFT JOIN 
        llx_product AS p ON fd.fk_product = p.rowid 
    WHERE 
        f.fk_soc IN (SELECT sc.fk_soc FROM llx_societe_commerciaux AS sc WHERE sc.fk_user = ' . $vendedorId . ')
        AND f.datef = CURDATE() 
        AND f.entity IN (1)';

    $resqlCobranzas = $mysqli->query($sqlCobranzas);
    if ($resqlCobranzas) {
        $row = $resqlCobranzas->fetch_object();
        $ventasCobranzasData[$vendedorId] = [
            'Total_Ventas' => $row->Total_Ventas ?: 0,
            'Total_Cobranzas' => $row->Total_Cobranzas ?: 0
        ];
    }
}

// Convertir datos a JSON
$ventasVolumenJSON = json_encode($ventasVolumenData);
$ventasCobranzasJSON = json_encode($ventasCobranzasData);

// Cierra la conexión
$mysqli->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <div class="container mt-5">
        <a href="https://alimentosriga.com/sistema/htdocs/" class="btn btn-secondary">
            <i class="bi bi-house custom-icon"></i>  <!-- Clase personalizada -->
        </a>
    </div>
    <title>Dashboard Principal</title>

    <!-- Vincula Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-size: 0.85rem; /* Tamaño de texto más pequeño */
            padding-left: 10px; /* Corrige el espacio */
            padding-top: 10px;
            margin: 0; /* Margen global */
            background-color: #f8f9fa;
        }
        .custom-icon {
            color: #FFA500; /* Cambia este valor por el color que desees */
        }

        .carousel-inner {
            padding: 2em 0;
        }

        .card {
            min-height: 360px;
            max-width: 250px;
            margin: 0 10px; /* Espacio entre tarjetas */
        }

        .d-flex {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px; /* Espacio entre las cartas */
        }

        /* Estilos para los botones de navegación */
        .carousel-control-prev, .carousel-control-next {
            background-color: rgba(0, 0, 0, 0.5); /* Fondo semi-transparente */
            border-radius: 50%; /* Bordes redondeados */
            width: 40px; /* Ancho del botón */
            height: 40px; /* Alto del botón */
        }

        .carousel-control-prev-icon, .carousel-control-next-icon {
            background-color: black; /* Color de la flecha */
            border-radius: 50%; /* Bordes redondeados para la flecha */
        }

        .carousel-control-prev:hover, .carousel-control-next:hover {
            background-color: rgba(0, 0, 0, 0.8); /* Fondo más oscuro al pasar el cursor */
        }

        /* Estilos para el contenedor del gráfico */
        .chart-wrapper {
            width: 100%; /* Ocupa todo el ancho disponible */
            height: 500px; /* Ajusta la altura según sea necesario */
            overflow: hidden; /* Oculta cualquier desbordamiento */
            background-color: #ffffff;
            padding: 2em 0;
        }

        .chart-container {
            position: relative;
            margin: auto;
            height: 100%; /* Se ajusta al contenedor padre */
            width: 100%; /* Se ajusta al contenedor padre */
        }

        canvas {
            width: 100% !important; 
            height: 100% !important;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h2>Bienvenido, (Supervisor)</h2>
    </div>

    <div class="row">
        <!-- Carrusel con tarjetas -->
        <?php if (!empty($vendedoresData)): ?>
            <div id="carouselExampleControls" class="carousel slide" data-bs-ride="false">
                <div class="carousel-inner">
                    <?php
                    // Inicializa la primera tarjeta como activa
                    $active = true;
                    $itemCount = 0; // Contador para las tarjetas

                    foreach ($vendedoresData as $data) {
                        // Inicia un nuevo item de carrusel cada 5 tarjetas
                        if ($itemCount % 5 == 0) {
                            if ($itemCount > 0) {
                                echo '</div>'; // Cierra el d-flex de tarjetas
                                echo '</div>'; // Cierra el carousel-item anterior
                            }
                            // Aquí se crea un nuevo carousel-item
                            echo '<div class="carousel-item '.($active ? 'active' : '').'">';
                            $active = false; // Desactiva el estado activo después del primer ítem
                            echo '<div class="d-flex">'; // Comienza el contenedor de tarjetas
                        }

                        // Muestra la tarjeta
                        echo '<div class="card">';
                        echo '<div class="card-body text-center">';
                        echo '<h5 class="card-title">'.$data['nombre'].'</h5>'; // Nombre del vendedor
                        echo '<p class="card-text">';
                        echo '<strong>Total Clientes:</strong> '.$data['clientes'].'<br>';
                        echo '<strong>Facturas Pendientes:</strong> '.$data['facturas'].'<br>';
                        echo '<strong>Clientes No Activos:</strong> '.$data['noactivos'].'<br>';
                        echo '<strong>Visitas Programadas:</strong> '.$data['visitas'].'<br>';
                        echo '</p>';
                        // echo '<a href="include/plan/Dashboard.php" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                        
                       //echo '<a href="planificacionindex2.php?vendedorId=' . $vendedorId . '&vendedorNombre=' . urlencode($vendedorNombre) . '" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                        
                        //echo '<a href="include/plan/Dashboard.php?vendedorId=' . $vendedorId . '" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                        
                        // Asumiendo que $data está definido y tiene los índices 'rowid' y 'nombre'
$vendedorId = $data['rowid'];
$vendedorNombre = $data['nombre'];

// Genera el enlace con los datos
echo '<a href="planificacionindex2.php?vendedorId=' . $vendedorId . '&vendedorNombre=' . urlencode($vendedorNombre) . '" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                        
                        echo '</div>'; // Cierra card-body
                        echo '</div>'; // Cierra card

                        $itemCount++; // Incrementa el contador de tarjetas
                    }

                    // Cierra el último d-flex y carousel-item después del bucle
                    if ($itemCount > 0) {
                        echo '</div>'; // Cierra el d-flex de tarjetas
                        echo '</div>'; // Cierra el carousel-item
                    }

                    // Botones de navegación del carrusel
                    echo '<button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">';
                    echo '<span class="carousel-control-prev-icon" aria-hidden="true"></span>';
                    echo '<span class="visually-hidden">Previous</span>';
                    echo '</button>';
                    echo '<button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">';
                    echo '<span class="carousel-control-next-icon" aria-hidden="true"></span>';
                    echo '<span class="visually-hidden">Next</span>';
                    echo '</button>';

                    echo '</div>'; // Cierra carousel
                    ?>
                </div>
            </div>
        <?php else: ?>
            <p>No hay usuarios disponibles.</p>
        <?php endif; ?>
    </div>

    <div class="row" style="padding-top:20px; text-align:center;">
        <!-- Card para el Gráfico de Ventas por Volumen -->
        <div class="col-md-6" style="padding-bottom:20px;"> <!-- Cambiar a col-md-6 para ocupar el 50% -->
            <div class="border-0 shadow">
                <div class="card-body">
                    <h5>Ventas Por Volumen Semana en Curso Por Vendedor</h5>
                    <div class="chart-wrapper" style="width: 100%; height: 500px;"> <!-- Mantenemos el ancho al 100% -->
                        <div class="chart-container">
                            <canvas id="salesBarChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card para el Gráfico de Ventas y Cobranzas -->
        <div class="col-md-6" style="padding-bottom:20px;"> <!-- Cambiar a col-md-6 para ocupar el 50% -->
            <div class="border-0 shadow">
                <div class="card-body">
                    <h5>Ventas y Cobranzas del Día en Curso</h5>
                    <div class="chart-wrapper" style="width: 100%; height: 500px;">
                        <div class="chart-container">
                            <canvas id="cobranzasChart"></canvas> <!-- Cambia el ID según sea necesario -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Asegúrate de incluir Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@latest"></script>

    <script>
      // Esperamos que el DOM esté completamente cargado
      document.addEventListener('DOMContentLoaded', function () {
        // Datos del gráfico de ventas por volumen
        const ventasVolumenData = <?php echo $ventasVolumenJSON; ?>;

        // Comprobación de datos
        console.log(ventasVolumenData); // Verifica los datos

        const vendedores = <?php echo json_encode(array_column($vendedoresData, 'nombre')); ?>; // Cambiar aquí para obtener los nombres
        // Comprobar si hay vendedores disponibles
        if (vendedores.length === 0) {
          console.error("No hay vendedores disponibles.");
          return; // Salir si no hay datos
        }

               const categorias = [...new Set([].concat(...Object.values(ventasVolumenData).map(v => Object.keys(v))))];
        // Comprobar si hay categorías disponibles
        if (categorias.length === 0) {
          console.error("No hay categorías disponibles.");
          return; // Salir si no hay categorías
        }

        const datasets = categorias.map(cat => {
          return {
            label: cat,
            data: vendedores.map(v => {
              // Obtener el ID del vendedor correspondiente al nombre
              const vendedorId = <?php echo json_encode(array_column($vendedoresData, 'rowid', 'nombre')); ?>[v]; 
              return ventasVolumenData[vendedorId] ? ventasVolumenData[vendedorId][cat] || 0 : 0;
            }), // Asignar valores o 0 si no hay datos
            backgroundColor: getRandomColor(), // Asigna un color aleatorio
            borderWidth: 1
          };
        });

        // Función para generar colores aleatorios
        function getRandomColor() {
          const letters = '0123456789ABCDEF';
          let color = '#';
          for (let i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
          }
          return color;
        }

        // Gráfico de Ventas por Volumen (Gráfico de Barras Apiladas)
        var ctxBar = document.getElementById('salesBarChart').getContext('2d');
        var salesBarChart = new Chart(ctxBar, {
          type: 'bar', // Tipo de gráfico
          data: {
            labels: vendedores,
            datasets: datasets // Usamos los datasets generados anteriormente
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
              x: {
                stacked: true,
                grid: { display: false },
                title: {
                  display: true,
                  text: 'Vendedores'
                },
                ticks: {
                  autoSkip: false // Desactiva el salto automático para mostrar todas las etiquetas
                }
              },
              y: {
                stacked: true,
                beginAtZero: true,
                grid: { display: false },
                title: {
                  display: true,
                  text: 'Cantidad'
                }
              }
            },
            plugins: {
              legend: {
                position: 'top',
              },
              tooltip: {
                callbacks: {
                  label: function(tooltipItem) {
                    return tooltipItem.dataset.label + ': ' + tooltipItem.raw;
                  }
                }
              }
            },
            elements: {
              bar: {
                borderRadius: {
                  topLeft: 8,
                  topRight: 8,
                  bottomLeft: 8,
                  bottomRight: 8
                }
              }
            },
            barThickness: 30 // Ajusta el grosor de las barras según sea necesario
          }
        });

        // Datos del gráfico de ventas y cobranzas
        const ventasCobranzasData = <?php echo $ventasCobranzasJSON; ?>;

        const datasetsCobranzas = [
          {
            label: 'Total Ventas',
            data: vendedores.map(v => {
              const vendedorId = <?php echo json_encode(array_column($vendedoresData, 'rowid', 'nombre')); ?>[v];
              return ventasCobranzasData[vendedorId] ? ventasCobranzasData[vendedorId].Total_Ventas : 0;
            }),
           // backgroundColor: 'rgba(75, 192, 192, 0.6)',
           backgroundColor: getRandomColor(), // Asigna un color aleatorio
            borderWidth: 1
          },
          {
            label: 'Total Cobranzas',
            data: vendedores.map(v => {
              const vendedorId = <?php echo json_encode(array_column($vendedoresData, 'rowid', 'nombre')); ?>[v];
              return ventasCobranzasData[vendedorId] ? ventasCobranzasData[vendedorId].Total_Cobranzas : 0;
            }),
           // backgroundColor: 'rgba(153, 102, 255, 0.6)',
             backgroundColor: getRandomColor(), // Asigna un color aleatorio
            borderWidth: 1
          }
        ];

       
        // Gráfico de Ventas y Cobranzas
        var ctxCobranzas = document.getElementById('cobranzasChart').getContext('2d');
        var cobranzasChart = new Chart(ctxCobranzas, {
          type: 'bar',
          data: {
            labels: vendedores,
            datasets: datasetsCobranzas
          },
          options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
              x: {
                title: {
                  display: true,
                  text: 'Vendedores'
                }
              },
              y: {
                beginAtZero: true,
                title: {
                  display: true,
                  text: 'Cantidad'
                }
              }
            },
            plugins: {
              legend: {
                position: 'top',
              },
              tooltip: {
                callbacks: {
                  label: function(tooltipItem) {
                    return tooltipItem.dataset.label + ': ' + tooltipItem.raw;
                  }
                }
              },
               elements: {
              bar: {
                borderRadius: {
                  topLeft: 8,
                  topRight: 8,
                  bottomLeft: 8,
                  bottomRight: 8
                }
              }
            },
            }
          }
        });
      });
    </script>

    <!-- Vincula Bootstrap JS y sus dependencias (Popper.js y Bootstrap Bundle) -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>

    <script>
    // Inicialización del Carrusel para que se inicie automáticamente con desplazamiento más lento y una sola tarjeta a la vez
    document.addEventListener('DOMContentLoaded', function () {
      var myCarousel = document.querySelector('#carouselExampleControls');
      var carousel = new bootstrap.Carousel(myCarousel, {
        interval: 5000, // Cambio a intervalo más razonable
        ride: 'carousel',
        wrap: true, // Para que el carrusel vuelva al inicio una vez que llegue al final
        slide: true, // Activar el desplazamiento de las tarjetas una por una
      });
    });
    </script>

</body>
</html>
