
 <?php 
 

 
 
 
 ?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modulo - Vendedores</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>
<body>
    <h1><i class="bi bi-calendar-event"></i> Planificación</h1>
    <hr>
    <div>
        <div class="d-flex justify-content-end">
            <p>Seleccione la Semana a Planificar:</p>
            <form id="date-form">
                <div class="input-group me-2" style="padding: 0px 30px;">
                    <input type="date" class="form-control" name="start_date" id="start_date" required>
                    <span class="input-group-text">a</span>
                    <input type="date" class="form-control" name="end_date" id="end_date" required>
                    <button class="btn btn-outline-dark" type="submit" id="planificar-btn">Planificar</button>
                </div>
            </form>
        </div>
    </div>

    <div class="container py-5" id="week-container">
        <div class="row" id="week-days">
            <!-- Los días de la semana se llenarán aquí dinámicamente -->
        </div>
    </div>

    <!-- Modal de registro de visita -->
    <div class="modal fade" id="visitModal" tabindex="-1" aria-labelledby="visitModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="visitModalLabel">Registrar Visita al Cliente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="visit-form">
                        <div class="mb-3">
                            <label for="visit-date" class="form-label">Fecha de Visita</label>
                            <input type="date" class="form-control" id="visit-date" required>
                        </div>
                        <div class="mb-3">
                            <label for="visit-type" class="form-label">Tipo de Visita</label>
                            <select class="form-select" id="visit-type" required>
                                <option value="Primera visita">Primera visita</option>
                                <option value="Seguimiento">Seguimiento</option>
                                <option value="Cierre de venta">Cierre de venta</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="visit-comments" class="form-label">Comentarios</label>
                            <textarea class="form-control" id="visit-comments" rows="3" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Guardar Visita</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Función para calcular los días de la semana sin incluir domingo
        function getWeekDays(startDate, endDate) {
            const start = new Date(startDate);
            const end = new Date(endDate);
            const daysOfWeek = [];
            
            // Asegúrate de que la fecha de inicio es un lunes
            const firstDay = start.getDate() - start.getDay() + 1; // Esto asegura que se empiece el lunes
            const lastDay = firstDay + 5; // Hasta sábado (5 días después)

            for (let i = firstDay; i <= lastDay; i++) {
                const date = new Date(start.setDate(i));
                daysOfWeek.push({
                    day: date.toLocaleString('default', { weekday: 'long' }),
                    date: date.toLocaleDateString()
                });
            }

            return daysOfWeek;
        }

        // Función para llenar las tarjetas de la semana
     
        function renderWeekCards(days) {
            const weekContainer = document.getElementById("week-days");
            
          
            weekContainer.innerHTML = ''; // Limpiar contenido previo

            days.forEach((day) => {
                const dayCard = `
                    <div class="col-4 mb-3">
                        <div class="card border-0 shadow">
                            <div class="card-body">
                            <div class="card-title text-center">
                                ${day.day} - ${day.date}
                            </div>
                                <ul id="${day.day.toLowerCase()}-tasks" class="task-list list-unstyled">
                                    <!-- Clientes del día se agregan aquí -->
                                </ul>
                                  <?php echo "8898999". $fecha; ?>
                                <button class="btn btn-outline-secondary border-0 w-100 mb-3" onclick="redirectToProgramCard()">+ Agregar Cliente</button>
                                
                            </div>
                        </div>
                    </div>
                `;
                weekContainer.innerHTML += dayCard;
            });
        }

        // Función para redirigir a la página de programación
        function redirectToProgramCard() {
            const visitDate = document.getElementById("visit-date").value;
            const url = `programa_card.php?action=create&idmenu=46&mainmenu=planificacion&leftmenu=&visitDate=${encodeURIComponent(visitDate)}`;
            window.location.href = url; // Redirige a la nueva URL
        }

        // Función para mostrar u ocultar el campo de entrada
        function toggleInput(dia) {
            const inputDiv = document.getElementById(`${dia}-input`);
            inputDiv.classList.toggle('d-none');
        }

        // Función para agregar un cliente a la lista
        function addClient(dia) {
            const clientName = document.getElementById(`${dia}-client`).value;
            if (clientName && clientName !== "Elegir Cliente") {
                const taskList = document.getElementById(`${dia}-tasks`);
                const li = document.createElement('li');
                li.innerHTML = `
                    <input type="checkbox" class="form-check-input me-2"> ${clientName}
                    <button class="btn btn-link link-dark btn-sm" onclick="openVisitModal('${clientName}')"> Marcar Visita</button>
                `;
                taskList.appendChild(li);

                // Limpiar el select
                document.getElementById(`${dia}-client`).value = "Elegir Cliente";
                toggleInput(dia);
            }
        }

        // Función para abrir el modal de visitas
        function openVisitModal(clientName) {
            // Cambiar el título del modal con el nombre del cliente
            document.getElementById("visitModalLabel").textContent = `Registrar Visita para ${clientName}`;
            // Crear la instancia del modal y mostrarlo
            const myModal = new bootstrap.Modal(document.getElementById('visitModal'));
            myModal.show();  // Abre el modal con el cliente seleccionado
        }

        // Al enviar el formulario de visita
        document.getElementById("visit-form").addEventListener("submit", function (e) {
            e.preventDefault();
            const visitDate = document.getElementById("visit-date").value;
            const visitType = document.getElementById("visit-type").value;
            const visitComments = document.getElementById("visit-comments").value;

            // Aquí puedes agregar lógica para guardar o procesar la visita
            console.log(`Visita registrada: ${visitDate}, ${visitType}, ${visitComments}`);

            // Cerrar el modal
            const myModal = bootstrap.Modal.getInstance(document.getElementById('visitModal'));
            myModal.hide();

            // Limpiar el formulario
            document.getElementById("visit-form").reset();
        });

        // Al enviar el formulario de fechas
        document.getElementById("date-form").addEventListener("submit", function (e) {
            e.preventDefault(); // Prevenir el comportamiento por defecto del formulario
            const startDate = document.getElementById("start_date").value;
            const endDate = document.getElementById("end_date").value;
            const days = getWeekDays(startDate, endDate);
            renderWeekCards(days); // Renderiza las tarjetas de la semana
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
