<?php
// Conexión a la base de datos
$host = 'localhost';
$db = 'aliment5_doli2';
$usuario = 'aliment5_root';
$pass = 'pluton007$';

$conn = new mysqli($host, $usuario, $pass, $db);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}



// Verificar si el parámetro 'id' está presente en la URL
if (isset($_GET['id'])) {
    // Obtener el valor del parámetro 'id'
    $VendedorId = intval($_GET['id']); // Convertir a entero para mayor seguridad
    echo "El Vendedor recibido es: " . $VendedorId;
} else {
    echo "No se proporcionó el ID.";
}



// Inicializar variables
$mensaje = '';
$resultado = null;



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create'])) {
        // Crear registro
        $ref = $_POST['ref'];
        $fk_soc = $_POST['fk_soc'];
        $fecha_visita = $_POST['fecha_visita'];
        $comentario = $_POST['comentario'];
        $status = $_POST['status'];
        $user = $VendedorId;

        // Verificar si ya existe un registro con la misma referencia
        $stmt = $conn->prepare("SELECT COUNT(*) FROM llx_planificacion_programa WHERE rowid = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count > 0) {
            $mensaje = "El registro ya existe.";
        } else {
            $stmt = $conn->prepare("INSERT INTO llx_planificacion_programa (ref, fk_soc, fecha_visita, comentario, status, date_creation, fk_user_creat) VALUES (?, ?, ?, ?, ?, NOW(), ?)");
            $stmt->bind_param("ssssss", $ref, $fk_soc, $fecha_visita, $comentario, $status, $user);
            if ($stmt->execute()) {
                $mensaje = "Registro creado exitosamente.";
            } else {
                $mensaje = "Error al crear el registro: " . $stmt->error;
            }
            $stmt->close();
        }
    }
    } elseif (isset($_POST['update'])) {
        // Actualizar registro
        $id = $_POST['id'];
        $ref = $_POST['ref'];
        $label = $_POST['label'];
        $fk_soc = $_POST['fk_soc'];
        $description = $_POST['description'];
        $note_public = $_POST['note_public'];
        $note_private = $_POST['note_private'];
        $fecha_visita = $_POST['fecha_visita'];
        $comentario = $_POST['comentario'];
        $telefono = $_POST['telefono'];
        $direccion = $_POST['direccion'];
        $contacto = $_POST['contacto'];
        $status = $_POST['status'];

        $stmt = $conn->prepare("UPDATE llx_planificacion_programa SET ref=?, label=?, fk_soc=?, description=?, note_public=?, note_private=?, fecha_visita=?, comentario=?, telefono=?, direccion=?, contacto=?, status=? WHERE rowid=?");
        $stmt->bind_param("ssssssssssssi", $ref, $label, $fk_soc, $description, $note_public, $note_private, $fecha_visita, $comentario, $telefono, $direccion, $contacto, $status, $id);
        if ($stmt->execute()) {
            $mensaje = "Registro actualizado exitosamente.";
        } else {
            $mensaje = "Error al actualizar el registro: " . $stmt->error;
        }
        $stmt->close();
    } elseif (isset($_POST['delete'])) {
        // Eliminar registro
        $id = $_POST['id'];
        $stmt = $conn->prepare("DELETE FROM llx_planificacion_programa WHERE rowid=?");
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $mensaje = "Registro eliminado exitosamente.";
        } else {
            $mensaje = "Error al eliminar el registro: " . $stmt->error;
        }
        $stmt->close();
    }


// Filtrar registros
$filtroCliente = '';
$filtroFechaInicio = '';
$filtroFechaFin = '';
if (isset($_GET['filtro_cliente']) && isset($_GET['filtro_fecha_inicio']) && isset($_GET['filtro_fecha_fin'])) {
    $filtroCliente = $_GET['filtro_cliente'];
    $filtroFechaInicio = $_GET['filtro_fecha_inicio'];
    $filtroFechaFin = $_GET['filtro_fecha_fin'];
}

// Obtener registros de clientes
$clientes = $conn->query("SELECT rowid, nom FROM llx_societe");
if (!$clientes) {
    die("Error en la consulta de clientes: " . $conn->error);
}

// Obtener registros de la semana actual agrupados por días
$sql = "
SELECT p.*, s.nom AS cliente 
FROM llx_planificacion_programa p 
LEFT JOIN llx_societe s ON p.fk_soc = s.rowid 
WHERE p.fecha_visita >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY
AND p.fecha_visita < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY
";

if (!empty($filtroCliente)) {
    $sql .= " AND p.fk_soc = ?";
}
if (!empty($filtroFechaInicio)) {
    $sql .= " AND p.fecha_visita >= ?";
}
if (!empty($filtroFechaFin)) {
    $sql .= " AND p.fecha_visita <= ?";
}

$sql .= " ORDER BY p.fecha_visita, p.rowid;";

$stmt = $conn->prepare($sql);
if ($stmt === false) {
    die("Error en la preparación de la declaración: " . $conn->error);
}

if (!empty($filtroCliente) || !empty($filtroFechaInicio) || !empty($filtroFechaFin)) {
    $params = [];
    $types = '';

    if (!empty($filtroCliente)) {
        $params[] = $filtroCliente;
        $types .= 'i'; // Tipo de dato para integer
    }
    if (!empty($filtroFechaInicio)) {
        $params[] = $filtroFechaInicio;
        $types .= 's'; // Tipo de dato para string
    }
    if (!empty($filtroFechaFin)) {
        $params[] = $filtroFechaFin;
        $types .= 's'; // Tipo de dato para string
    }

    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$resultado = $stmt->get_result();
$stmt->close();

// Cerrar conexión
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <title>CRUD Planificación Programa</title>
    
    <style>
        body {
            background-color: #f8f9fa; /* Color de fondo */
            font-size: 14px; /* Tamaño de fuente global */
        }
        .header {
            display: flex;
            align-items: center; /* Centrar verticalmente */
            background-color: #007bff; /* Fondo azul */
            color: white; /* Texto blanco */
            padding: 10px; /* Espaciado interno */
            border-radius: 10px; /* Bordes redondeados */
            margin-bottom: 20px; /* Espacio inferior */
        }
        .header img {
            width: 200px; /* Ancho del logotipo */
            height: auto; /* Mantener proporciones */
            margin-right: 15px; /* Espacio entre el logo y el título */
        }
        .card {
            background-color: #ffffff; /* Fondo blanco para la tarjeta */
            border-radius: 10px; /* Bordes redondeados */
            padding: 4px; /* Espaciado interno reducido */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
            margin-bottom: 10px; /* Espacio entre tarjetas */
            width: fit-content; /* Ancho según su contenido */
        }
        .form-control {
            border-radius: 5px; /* Bordes redondeados en los campos */
            font-size: 1rem; /* Tamaño de fuente para los campos del formulario */
        }
        .btn {
            border-radius: 5px; /* Bordes redondeados en los botones */
            font-size: 1rem; /* Tamaño de fuente para los botones */
        }
        .alert {
            margin-top: 20px; /* Espacio superior para el mensaje */
        }
        .status-indicator {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            display: inline-block;
            margin-right: 5px;
        }
        .status-0 {
            background-color: yellow;
        }
        .status-1 {
            background-color: green;
        }
        .dia-semana {
            display: flex; /* Usar flexbox para alinear los días en una fila */
            flex-wrap: wrap; /* Permitir que los elementos se envuelvan en caso de que no haya espacio */
            justify-content: flex-start; /* Alinear a la izquierda */
        }
        .dia {
            flex: 1 1 30%; /* Cada día ocupa un 30% del ancho disponible, ajusta según necesites */
            margin: 5px; /* Espacio reducido entre días */
        }
		
		.icono-boton {
    width: 30px; /* Cambia el tamaño según sea necesario */
    height: auto; /* Mantiene la proporción */
}


.btn {
    /* background: transparent;  Para que el botón sea transparente */
    border: none; /* Sin borde */
    padding: 0; /* Sin padding */
}

.btn i {
    font-size: 24px; /* Cambia el tamaño del ícono */
    color: #000; /* Cambia el color del ícono */
}

.btn:hover i {
    color: #007bff; /* Cambia el color al pasar el mouse */
}
    </style>
	
</head>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<body>
<div class="container mt-5">
    <div class="header">
        <img src="img/logo.png" alt="Logotipo">
        <h2 class="m-0">Dashboard Planificación</h2>
    </div>

    <?php if ($mensaje): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($mensaje); ?></div>
    <?php endif; ?>

    <form method="GET" class="mb-4">
        <div class="form-row">
            <div class="col-md-4">
                <input type="text" name="filtro_cliente" class="form-control" placeholder="Filtrar por cliente" value="<?php echo htmlspecialchars($filtroCliente); ?>">
            </div>
            <div class="col-md-4">
                <input type="date" name="filtro_fecha_inicio" class="form-control" placeholder="Fecha Inicio" value="<?php echo htmlspecialchars($filtroFechaInicio); ?>">
            </div>
            <div class="col-md-4">
                <input type="date" name="filtro_fecha_fin" class="form-control" placeholder="Fecha Fin" value="<?php echo htmlspecialchars($filtroFechaFin); ?>">
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-block mt-3">Filtrar</button>
        <a href="dashboard_planicacionpedro.php" class="btn btn-secondary btn-block">Quitar Filtro</a>
    </form>
</div>


 <div class="container mt-5">
        <button id="toggleForm" class="btn btn-primary mb-3">Nueva</button>
        <div id="formContainer" style="display: none;">
            <h3 class="text-center">Crear Visita</h3>
            <div class="card mb-4">
                <div class="card-body">
                    <form method="POST" id="newRecordForm">
                        <div class="form-row">
                            <div class="col-md-6 mb-3">
                                <label for="ref">Referencia</label>
                                <input type="text" name="ref" class="form-control" placeholder="Referencia" required>
                            </div>
                            <!-- <div class="col-md-6 mb-3">
                                <label for="label">Etiqueta</label>
                                <input type="text" name="label" class="form-control" placeholder="Etiqueta" required>
                            </div> -->
                            <div class="col-md-6 mb-3">
                                <label for="fk_soc">Cliente</label>
                                <select name="fk_soc" class="form-control" required>
                                    <option value="">Seleccionar Cliente</option>
                                    <?php while ($cliente = $clientes->fetch_assoc()): ?>
                                        <option value="<?php echo $cliente['rowid']; ?>"><?php echo htmlspecialchars($cliente['nom']); ?></option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <!-- <div class="col-md-6 mb-3">
                                <label for="description">Descripción</label>
                                <input type="text" name="description" class="form-control" placeholder="Descripción">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="note_public">Nota Pública</label>
                                <input type="text" name="note_public" class="form-control" placeholder="Nota Pública">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="note_private">Nota Privada</label>
                                <input type="text" name="note_private" class="form-control" placeholder="Nota Privada">
                            </div> -->
                            <div class="col-md-6 mb-3">
                                <label for="fecha_visita">Fecha Visita</label>
                                <input type="date" name="fecha_visita" class="form-control" placeholder="Fecha Visita" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="comentario">Comentario</label>
                                <input type="text" name="comentario" class="form-control" placeholder="Comentario">
                             <!--</div>
                            <div class="col-md-6 mb-3">
                                <label for="telefono">Teléfono</label>
                                <input type="text" name="telefono" class="form-control" placeholder="Teléfono">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="direccion">Dirección</label>
                                <input type="text" name="direccion" class="form-control" placeholder="Dirección">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="contacto">Contacto</label>
                                <input type="text" name="contacto" class="form-control" placeholder="Contacto">
                            </div>  -->
                            <div class="col-md-6 mb-3">
                                <label for="status">Estado</label>
                                <select name="status" class="form-control" required>
                                    <option value="0">Programada</option>
                                    <option value="1">Validada</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" name="create" class="btn btn-success btn-block">Agregar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>





<div class="container-fluid mt-5">
    <div class="row dia-semana">
    <?php if ($resultado): 
        $datosPorDia = [];
        while ($fila = $resultado->fetch_assoc()) {
            $fecha = date('Y-m-d', strtotime($fila['fecha_visita']));
            if (!isset($datosPorDia[$fecha])) {
                $datosPorDia[$fecha] = [];
            }
            $datosPorDia[$fecha][] = $fila;
        }

        foreach ($datosPorDia as $dia => $datos): ?>
            <div class="col-12 dia">
                <div class="card">
                    <div class="card-body">
                      <h5 class="card-title"><?php echo strftime('%A, %d %B %Y', strtotime($dia)); ?></h5> <!-- Muestra el día en español -->
                        <?php foreach ($datos as $fila): ?>
                            <p>
                               <strong>Planificación ID:</strong> 
                                      <?php echo htmlspecialchars($fila['rowid']) . ' '; ?>
                                <span class="status-indicator <?php echo $fila['status'] == 0 ? 'status-0' : 'status-1'; ?>"></span>
                            </p>
                            <p><strong>Referencia:</strong> <?php echo htmlspecialchars($fila['ref']); ?></p>
                            <p><strong>Cliente:</strong> <?php echo htmlspecialchars($fila['cliente']); ?></p>
                            <p><strong>Comentario:</strong> <?php echo htmlspecialchars($fila['comentario']); ?></p>
                            <form method="POST" class="modify-form">
                                <input type="hidden" name="id" value="<?php echo $fila['rowid']; ?>">
                                <input type="hidden" name="ref" value="<?php echo htmlspecialchars($fila['ref']); ?>">
                                <input type="hidden" name="label" value="<?php echo htmlspecialchars($fila['label']); ?>">
                                <input type="hidden" name="fk_soc" value="<?php echo htmlspecialchars($fila['fk_soc']); ?>">
                                <input type="hidden" name="description" value="<?php echo htmlspecialchars($fila['description']); ?>">
                                <input type="hidden" name="note_public" value="<?php echo htmlspecialchars($fila['note_public']); ?>">
                                <input type="hidden" name="note_private" value="<?php echo htmlspecialchars($fila['note_private']); ?>">
                                <input type="hidden" name="fecha_visita" value="<?php echo htmlspecialchars($fila['fecha_visita']); ?>">
                                <input type="hidden" name="comentario" value="<?php echo htmlspecialchars($fila['comentario']); ?>">
                                <input type="hidden" name="telefono" value="<?php echo htmlspecialchars($fila['telefono']); ?>">
                                <input type="hidden" name="direccion" value="<?php echo htmlspecialchars($fila['direccion']); ?>">
                                <input type="hidden" name="contacto" value="<?php echo htmlspecialchars($fila['contacto']); ?>">
                                <input type="hidden" name="status" value="<?php echo htmlspecialchars($fila['status']); ?>">
                                <button type="button" class="btn" onclick="enableFields(this)">
    <i class="fas fa-edit"></i> <!-- Ícono de modificar -->
</button>
<button type="submit" name="update" class="btn" style="display:none;">
    <i class="fas fa-check"></i> <!-- Ícono de actualizar -->
</button>
<button type="button" class="btn" onclick="cancelEdit(this)" style="display:none;">
    <i class="fas fa-times"></i> <!-- Ícono de cancelar -->
</button>
<button type="submit" name="delete" class="btn">
    <i class="fas fa-trash"></i> <!-- Ícono de eliminar -->
</button>

                            </form>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; endif; ?>
    </div>

   

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        function enableFields(button) {
            const form = button.closest('form');
            const inputs = form.querySelectorAll('input[type="hidden"]');
            inputs.forEach(input => {
                const inputField = document.createElement('input');
                inputField.type = 'text';
                inputField.name = input.name;
                inputField.value = input.value;
                inputField.className = 'form-control mb-2';
                form.insertBefore(inputField, button);
                input.remove(); // Eliminar el campo oculto
            });
            button.style.display = 'none'; // Ocultar botón de modificar
            form.querySelector('button[name="update"]').style.display = 'inline'; // Mostrar botón de actualización
            form.querySelector('button[type="button"].btn-secondary').style.display = 'inline'; // Mostrar botón de cancelar
        }

        function cancelEdit(button) {
            const form = button.closest('form');
            const inputs = form.querySelectorAll('input[type="text"]');
            inputs.forEach(input => {
                const hiddenInput = document.createElement('input');
                hiddenInput.type = 'hidden';
                hiddenInput.name = input.name;
                hiddenInput.value = input.value;
                form.insertBefore(hiddenInput, input);
                input.remove(); // Eliminar el campo editable
            });
            button.style.display = 'none'; // Ocultar botón de cancelar
            form.querySelector('button[type="button"].btn-info').style.display = 'inline'; // Mostrar botón de modificar
        }

        // Mostrar/Ocultar formulario de nuevo registro
        document.getElementById('toggleForm').addEventListener('click', function() {
            const formContainer = document.getElementById('formContainer');
            formContainer.style.display = formContainer.style.display === 'none' ? 'block' : 'none';
        });

        // Ocultar el formulario al crear un nuevo registro
        document.getElementById('newRecordForm').addEventListener('submit', function() {
            document.getElementById('formContainer').style.display = 'none';
        });
    </script>
</body>
</html>

