<?php
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

// Verificar la conexión
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

$clienteId = isset($_GET['id']) ? intval($_GET['id']) : null;
// info cliente

$nombre_cliente = $mysqli->query('SELECT nom as nombre_cliente
FROM llx_societe
WHERE rowid = '. $clienteId);

if($nombre_cliente){
    $resultado = $nombre_cliente->fetch_assoc();
    $nombre_cliente = $resultado['nombre_cliente'];
}
// consulta de riesgo alcanzado REVISAR
$riesgo_alcanzado = $mysqli->query('SELECT SUM(total_ttc) AS saldo
FROM llx_facture
WHERE fk_soc = ' . $clienteId . '
AND fk_statut = 1');

if ($riesgo_alcanzado) {
    // Obtener el resultado
    $resultado = $riesgo_alcanzado->fetch_assoc();
    $saldo = $resultado['saldo'] ?? 0;
} else {
    $saldo = 0; 
}
// consulta tickets por mes 
$tickets_total = $mysqli->query('SELECT sum(cantidad) AS tickets_total
FROM (
SELECT MONTH(datef) AS mes, COUNT(ref) AS cantidad
FROM llx_facture
WHERE fk_soc = ' . $clienteId . '
GROUP BY MONTH(datef), YEAR(datef)
) AS subconsulta'
    );
    
if($tickets_total){
    $resultado = $tickets_total->fetch_assoc();
    $tickets_total = $resultado['tickets_total'];
    $meses = date('n');
    $prom_tickets = $tickets_total / $meses;
}

// consulta de ultima factura
$ultima_factura = $mysqli->query('SELECT total_ttc AS ultima_factura, datef 
FROM llx_facture 
WHERE fk_soc = ' . $clienteId . ' 
AND datef = (SELECT MAX(datef) FROM llx_facture WHERE fk_soc = ' . $clienteId . ')'
    );
 
if ($ultima_factura) {
    // Obtener el resultado
    $resultado = $ultima_factura->fetch_assoc();
    $ultima_factura = $resultado['ultima_factura'] ?? 0;
}

// Consulta para contar las facturas por mes
$query = "SELECT MONTH(datef) AS mes, COUNT(ref) AS cantidad
          FROM llx_facture
          WHERE fk_soc = " .$clienteId. "
          GROUP BY MONTH(datef), YEAR(datef)
          ORDER BY MONTH(datef)";

$result = $mysqli->query($query);

$frecuencia = [];
while ($row = $result->fetch_assoc()) {
    $frecuencia[$row['mes']] = $row['cantidad'];
}

// Rellenar con ceros para meses sin datos
$meses = [];
$data = [];

for ($mes = 1; $mes <= 12; $mes++) {
    $meses[] = date("M", mktime(0, 0, 0, $mes, 1)); // Nombre del mes
    $data[] = isset($frecuencia[$mes]) ? $frecuencia[$mes] : 0; // Cantidad o 0 si no hay datos
}

// Consulta para obtener los 5 productos más facturados
$productos_top = "
    SELECT p.label AS producto, SUM(fd.total_ht) AS total_facturado
    FROM llx_facture AS f
    JOIN llx_societe AS s ON f.fk_soc = s.rowid
    JOIN llx_facturedet AS fd ON fd.fk_facture = f.rowid
    JOIN llx_product AS p ON fd.fk_product = p.rowid 
    WHERE s.rowid = " . $clienteId . "
    GROUP BY p.label
    ORDER BY total_facturado DESC
    LIMIT 5
";

$result = $mysqli->query($productos_top);

// consulta para venta por categoria
// Ejecutar la consulta
$venta_categoria = "
    SELECT DISTINCT 
    y.label AS Categoria, SUM(fd.total_ht) AS Cantidad 
    FROM 
        llx_societe AS s 
    LEFT JOIN 
        llx_facture AS f ON f.fk_soc = s.rowid 
    LEFT JOIN 
        llx_facturedet AS fd ON f.rowid = fd.fk_facture 
    LEFT JOIN 
        llx_facture_extrafields AS extra ON f.rowid = extra.fk_object 
    LEFT JOIN 
        llx_facturedet_extrafields AS extra2 ON fd.rowid = extra2.fk_object 
    LEFT JOIN 
        llx_product AS p ON fd.fk_product = p.rowid 
    LEFT JOIN 
        llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object 
    LEFT JOIN 
        llx_categorie_product AS cp ON cp.fk_product = p.rowid 
    LEFT JOIN 
        llx_categorie AS y ON y.rowid = cp.fk_categorie 
    WHERE 
        s.rowid = " . $clienteId . "
    GROUP BY 
        Categoria 
    ORDER BY 
        Categoria;
";

$venta_categoria = $mysqli->query($venta_categoria);

// Inicializar arrays para las etiquetas y los datos
$categorias = [];
$cantidades = [];

// Recoger los resultados
while ($row = $venta_categoria->fetch_assoc()) {
    $categorias[] = $row['Categoria'];
    $cantidades[] = $row['Cantidad'];
}
//productos sugeridos
$productos_sugeridos = "
    SELECT 
        p.label AS Productos_sin_comprar, 
        MAX(f.datef) AS UltimaFactura,
        DATEDIFF(CURDATE(), MAX(f.datef)) AS DiasInactivos
    FROM 
        llx_societe AS s 
    LEFT JOIN 
        llx_facture AS f ON f.fk_soc = s.rowid 
    LEFT JOIN 
        llx_facturedet AS fd ON f.rowid = fd.fk_facture 
    LEFT JOIN 
        llx_facture_extrafields AS extra ON f.rowid = extra.fk_object 
    LEFT JOIN 
        llx_facturedet_extrafields AS extra2 ON fd.rowid = extra2.fk_object 
    LEFT JOIN 
        llx_product AS p ON fd.fk_product = p.rowid 
    LEFT JOIN 
        llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object 
    LEFT JOIN 
        llx_categorie_product AS cp ON cp.fk_product = p.rowid 
    WHERE 
        s.rowid = " . $clienteId . "
        AND p.label NOT IN (
            SELECT DISTINCT p2.label 
            FROM llx_societe AS s2 
            LEFT JOIN llx_facture AS f2 ON s2.rowid = f2.fk_soc 
            LEFT JOIN llx_facturedet AS fd2 ON f2.rowid = fd2.fk_facture 
            LEFT JOIN llx_product AS p2 ON fd2.fk_product = p2.rowid 
            WHERE 
                f2.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
                AND s2.rowid = " . $clienteId . "
        )
    GROUP BY 
        p.label
    ORDER BY 
        DiasInactivos DESC
    LIMIT 4;  -- Limitar a 4 resultados
";

$sugeridos = $mysqli->query($productos_sugeridos);

//formateo 
$saldo = number_format($saldo, 2, ',', '.');
$ultima_factura = number_format($ultima_factura,2,',','.');
$prom_tickets = number_format($prom_tickets,2,',','.');


$mysqli->close();
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Informacion Cilentes</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .card {
    transition: transform 0.3s ease, box-shadow 0.3s ease; /* Transición suave para el desplazamiento y la sombra */
  }

  .card:hover {
    transform: translateY(-10px); /* Desplazar ligeramente hacia arriba */
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2); /* Sombra más fuerte para resaltar el efecto */
  }
  body{
      padding: 50px 50px 50px 100px;
  }
    </style>
</head>
<body>
     <h3><i class="bi bi-person-fill"></i>  <?php echo htmlspecialchars($nombre_cliente); ?>
     </h3>
    <hr>

<div class="row row-cols-1 row-cols-sm-3 text-center" style="margin-top: 25px;">

    <div class="col">
        <div class="card mb-4 border-0 rounded-2 shadow" >
            <div class="card-body">
            <p><small class="text-muted">Ultima Factura</small></p>
                <h2 class="card-title pricing-card-title" style="font-size: 1.5rem;">
                    <?php echo htmlspecialchars($ultima_factura); ?> $
                    <small class="text-muted fw-light"></small>
                </h2>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card mb-4 border-0 rounded-3 shadow">
            <div class="card-body">
            <p><small class="text-muted">Frecuencias de Compras del Mes</small></p>
                <h2 class="card-title pricing-card-title" style="font-size: 1.5rem;">
                    <?php echo htmlspecialchars($prom_tickets); ?>
                    <small class="text-muted fw-light"></small>
                </h2>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card mb-4 border-0 rounded-3 shadow">
            <div class="card-body">
            <p><small class="text-muted">Riesgo Alcanzado</small></p>
                <h2 class="card-title pricing-card-title" style="font-size: 1.5rem; color:red;">
                    <?php echo htmlspecialchars($saldo); ?> $
                    <small class="text-muted fw-light"></small>
                </h2>
            </div>
        </div>
    </div>
</div>

<!-- Gráfico de líneas con frecuencia de compras y productos top -->
<div class="row">
    <!-- Gráfico: 8 columnas -->
    <div class="col-md-8";>
      <div class="card mb-4 border-0 rounded-3 shadow">
        <div class="card-body">
          <h5 class="card-title">Frecuencia de Compra</h5>
          <div class="chart-container 200 px">
            <canvas id="lineChart"></canvas>
          </div>
        </div>
      </div>
    </div>

    <!-- Productos Top: 4 columnas -->
    <div class="col-md-4">
      <div class="card mb-4 border-0 rounded-3 shadow ">
        <div class="card-body">
          <?php 
          // Comenzar la lista HTML
            echo '<h5 class="card-title">Productos Top</h5>';
            echo '<ul class="list-group">';

         // Iterar sobre los resultados y crear los elementos de la lista
                while ($row = $result->fetch_assoc()) {
                $producto = $row['producto'];
                // Formatear el total a 2 decimales y agregar separadores de miles
                    $total_facturado = number_format($row['total_facturado'], 2, '.', ','); 
            echo "<li class='list-group-item'><strong>{$producto}</strong> - <span>\${$total_facturado}</span></li>";
                }

                // Cerrar la lista
                echo '</ul>';

          ?>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
    const ctx = document.getElementById('lineChart').getContext('2d');
    const lineChart = new Chart(ctx, {
      type: 'line',
      data: {
        labels: <?php echo json_encode($meses); ?> , // Meses
        datasets: [{
          label: 'Numero de Tickets',
          data: <?php echo json_encode($data); ?>, // Frecuencia de compras por mes
          borderColor: 'rgba(255, 165, 0, 1)',          // Naranja (color sólido para los bordes)
          backgroundColor: 'rgba(255, 165, 0, 0.2)',    // Naranja (color con opacidad para el fondo)
          tension: 0.2,
          fill: false,
          pointRadius: 3.5,
        pointBackgroundColor: 'rgba(255, 165, 0, 1)', // Naranja (color para los puntos)
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
          y: {
            beginAtZero: true,
            ticks: {
              stepSize: 5
            },
            grid: {
              display: false  // Quita las líneas de cuadrícula del eje Y
            }
          }
        },

        x: {
          grid: {
            display: false  // Quita las líneas de cuadrícula del eje X
          }
        }
      },
        plugins: {
          legend: {
            display: false
          }
        }
      }
    );
  </script>
<div class="container mt-5">
    <div class="row">
        <!-- Sección de Productos Sugeridos -->
<?php
echo '<div class="col-md-4">';
echo '<h4 class="mb-4">Productos Sugeridos</h4>';
echo '<div class="product-list">';

// Crear tarjetas de productos
if ($result->num_rows > 0) {
    while ($row = $sugeridos->fetch_assoc()) {
        echo '<div class="product-item">';
        echo '<div class="card border-0">';
        echo '<div class="card-body">';
        echo '<h5>' . htmlspecialchars($row['Productos_sin_comprar']) . '</h5>';
        echo '<p>Ultima Compra: ' . htmlspecialchars($row['UltimaFactura']) . '</p>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
} 
echo '</div>'; // Cierre de product-list
echo '</div>'; // Cierre de col-md-3
?>
    

        <div class="col-md-8">
          <div class="card border-0">
            <div class="card-body">
              <h4 class="mb-4">Venta por Categoría</h4>
              <div class="chart-container">
                  <canvas id="ventaChart" width="300" height="300"></canvas>
              </div>
            </div>
          </div>
        </div>
    </div>
</div>
</body>
<script>
    // Oportunidad de Venta - Gráfico de Potencial de Venta Apilado
    var ctx1 = document.getElementById('ventaChart').getContext('2d');
    var ventaChart = new Chart(ctx1, {
        type: 'bar',
        data: {
            labels: <?php echo json_encode($categorias); ?>,
            datasets: [
                {
                    label: 'Venta',
                    data: <?php echo json_encode($cantidades); ?>, 
                    backgroundColor: '#E53935',
                    borderColor: '#fff',
                    borderWidth: 2,
                    borderRadius: 8,
                    barThickness: 25,
                },
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: {
                    beginAtZero: true,
                    grid: {
                        display: false
                    },
                },
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 50
                    },
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderRadius: 5,
                    padding: 10,
                }
            },
            interaction: {
                mode: 'index',
                intersect: false,
            },
            animation: {
                duration: 1000,
                easing: 'easeInOutQuad',
            },
            stacked: true, // Las barras se apilan
        }
    });
</script>