<?php
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

// Obtener el vendedorId
$vendedorId = isset($_GET['vendedorId']) ? intval($_GET['vendedorId']) : null;

//echo "El ID del vendedor es: " . htmlspecialchars($vendedorId);

if (!$vendedorId) {
    die("Error: ID de vendedor no proporcionado.");
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes con Saldo Vencido</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        h1 { font-size: 40px; color: #333; margin-bottom: 40px; }
        .card { border-radius: 10px; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1); }
        .table { border-radius: 8px; }
        .table th, .table td { vertical-align: middle; }
        .table thead { background-color: #fff; color: #333; }
        .table tbody tr:hover { background-color: #f1f1f1; }
    </style>
</head>

<body>
    <div class="container">
        <h1 class="text-left">Clientes con Saldo Vencido</h1>
        <hr>

        <div class="card mb-4 border-0 rounded-2 shadow">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Número</th>
                                <th>Nro Factura</th>
                                <th>CLIENTE</th>
                                <th>FECHA DE FACTURACIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query = $mysqli->query("SELECT DISTINCT f.ref AS nro_factura, s.nom AS nombre_cliente, f.datef AS fecha_facturacion
                                                     FROM llx_societe AS s 
                                                     LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                                                     LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                                                     LEFT JOIN llx_facture AS f ON f.fk_soc = s.rowid 
                                                     WHERE f.fk_statut = 1 
                                                     AND f.entity IN (1) 
                                                     AND u.rowid = " . $vendedorId);

                            if ($query) {
                                if ($query->num_rows > 0) {
                                    $index = 1; // Para numerar los clientes
                                    while ($res = $query->fetch_object()) {
                                        echo "<tr>";
                                        echo "<td>" . htmlspecialchars($index++) . "</td>";
                                        echo "<td>" . htmlspecialchars($res->nro_factura) . "</td>";
                                        echo "<td>" . htmlspecialchars($res->nombre_cliente) . "</td>";
                                        echo "<td>" . date('d-m-Y', strtotime($res->fecha_facturacion)) . "</td>";
                                        echo "</tr>";
                                    }
                                } else {
                                    echo "<tr><td colspan='4'>No hay clientes con saldo vencido.</td></tr>";
                                }
                            } else {
                                echo "<tr><td colspan='4'>Error en la consulta: " . htmlspecialchars($mysqli->error) . "</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
