<?php
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

if ($mysqli->connect_error) {
    die("Conexi贸n fallida: " . $mysqli->connect_error);
}

// Obtener el vendedorId
$vendedorId = isset($_GET['vendedorId']) ? intval($_GET['vendedorId']) : null;

//echo "El ID del vendedor es: " . htmlspecialchars($vendedorId);

if (!$vendedorId) {
    die("Error: ID de vendedor no proporcionado.");
}
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes Inactivos</title>
    <link rel="stylesheet" href="style.css">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome para íconos -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <!-- Estilos personalizados -->
</head>

<body>
    <div class="container">
        <h1 class="text-left">Clientes Inactivos</h1>
        <hr>

        <!-- Card para la tabla -->
        <div class="card mb-4 border-0 rounded-2 shadow">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Cliente</th>
                                <th>Última Compra (Fecha)</th>
                                <th>Días Inactivos</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Consulta SQL
                            $sql = "SELECT 
                                    s.nom AS ClientesNoactivos, 
                                    MAX(f.datef) AS UltimaFactura,
                                    DATEDIFF(CURDATE(), MAX(f.datef)) AS DiasInactivos
                                FROM 
                                    llx_societe AS s
                                LEFT JOIN 
                                    llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
                                LEFT JOIN 
                                    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                                LEFT JOIN 
                                    llx_user AS u ON sc.fk_user = u.rowid 
                                LEFT JOIN 
                                    llx_facture AS f ON s.rowid = f.fk_soc 
                                WHERE 
                                    u.rowid = $vendedorId
                                    AND s.status = 1
                                    AND s.nom NOT IN (
                                        SELECT DISTINCT s.nom 
                                        FROM llx_societe AS s 
                                        LEFT JOIN llx_facture AS f ON s.rowid = f.fk_soc 
                                        LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                                        LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                                        WHERE 
                                            f.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
                                            AND u.rowid = $vendedorId
                                    )
                                GROUP BY 
                                    s.nom
                                ORDER BY DiasInactivos DESC;";

                            $result = $mysqli->query($sql);

                            if ($result->num_rows > 0) {
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>";
                                    echo "<td>" . $row["ClientesNoactivos"] . "</td>";
                                    echo "<td>" . $row["UltimaFactura"] . "</td>";
                                    echo "<td>" . $row["DiasInactivos"] . "</td>";
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='3'>No se encontraron clientes inactivos.</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS (opcional para funcionalidades de interactividad) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
