<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Conexiones a las bases de datos
$local_conn = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');
$remote_conn = new mysqli('198.50.175.169', 'guayoyoc_root', 'pluton007$', 'guayoyoc_doli2');

// Verificar conexiones
if ($local_conn->connect_error) {
    die("Conexión local fallida: " . $local_conn->connect_error);
}
if ($remote_conn->connect_error) {
    die("Conexión remota fallida: " . $remote_conn->connect_error);
}

// Obtener las fechas seleccionadas
$fecha_inicio = isset($_POST['fecha_inicio']) ? $_POST['fecha_inicio'] : null;
$fecha_fin = isset($_POST['fecha_fin']) ? $_POST['fecha_fin'] : null;

// Establecer rangos de fechas
if ($fecha_inicio && $fecha_fin) {
    $fecha_inicio_sql = $fecha_inicio . " 00:00:00";
    $fecha_fin_sql = $fecha_fin . " 23:59:59";
} else {
    // Si no se seleccionan fechas, usar el rango predeterminado (semana actual)
    $fecha_inicio_sql = date('Y-m-d', strtotime('monday this week')) . " 00:00:00";
    $fecha_fin_sql = date('Y-m-d', strtotime('sunday this week')) . " 23:59:59";
}

// Consulta para RIGA (Local)
$riga_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre, 
    COUNT(DISTINCT s.nom) AS cantidad_clientes,
    SUM(f.total) AS total_ventas
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc
WHERE 
    s.status = 1 
    AND us.fk_usergroup = 1
    AND f.datef >= '$fecha_inicio_sql' 
    AND f.datef <= '$fecha_fin_sql'
GROUP BY 
    nombre;
";

$riga_result = $local_conn->query($riga_query);

// Calcular el total de ventas para el porcentaje
$total_ventas_riga = 0;
$total_cantidad_riga = 0; // Para totalizar cantidad
while ($row = $riga_result->fetch_assoc()) {
    $total_ventas_riga += $row['total_ventas'];
    $total_cantidad_riga += $row['cantidad_clientes']; // Sumar cantidad
}
$riga_result->data_seek(0); // Reiniciar el puntero de resultados

// Consulta para GUAYOYO (Remoto)
$guayoyo_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre,
    COUNT(DISTINCT s.nom) AS cantidad_clientes,
    SUM(f.total) AS TotalFacturas
FROM 
    llx_facture AS f 
LEFT JOIN 
    llx_societe AS s ON f.fk_soc = s.rowid 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    f.entity IN (1) 
    AND us.fk_usergroup = 1
    AND f.datef >= '$fecha_inicio_sql' 
    AND f.datef <= '$fecha_fin_sql'
    AND f.fk_statut IN (1, 2) 
GROUP BY 
    nombre;
";

$guayoyo_result = $remote_conn->query($guayoyo_query);
        
        // Consulta para obtener Asesores sin Venta en RIGA
$sin_venta_riga_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
    COUNT(CASE WHEN f.datef >= '$fecha_inicio_sql'
                AND f.datef < '$fecha_fin_sql'
           THEN f.rowid END) = 0;
";

$sin_venta_riga_result = $local_conn->query($sin_venta_riga_query);

// Consulta para obtener Asesores sin Venta en GUAYOYO
$sin_venta_guayoyo_query = "
SELECT 
    CONCAT(u.firstname, ' ', u.lastname) AS nombre
FROM 
    llx_user AS u
LEFT JOIN 
    llx_societe_commerciaux AS sc ON u.rowid = sc.fk_user
LEFT JOIN 
    llx_societe AS s ON sc.fk_soc = s.rowid
LEFT JOIN 
    llx_facture AS f ON s.rowid = f.fk_soc 
LEFT JOIN 
    llx_usergroup_user AS us ON u.rowid = us.fk_user
WHERE 
    s.status = 1 
    AND u.statut = 1 
    AND us.fk_usergroup = 1
GROUP BY 
    nombre
HAVING 
   COUNT(CASE WHEN f.datef >= '$fecha_inicio_sql'
                AND f.datef < '$fecha_fin_sql'
           THEN f.rowid END) = 0;
";

$sin_venta_guayoyo_result = $remote_conn->query($sin_venta_guayoyo_query);
        
        
  // Obtener vendedores
$vendedores_riga = $local_conn->query("SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre FROM llx_user as u LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user WHERE u.statut = 1 AND us.fk_usergroup = 1");
$vendedores_guayoyo = $remote_conn->query("SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre FROM llx_user as u LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user WHERE u.statut = 1 AND us.fk_usergroup = 1");


$ventasVolumenDataRiga = [];
$ventasVolumenDataGuayoyo = [];

function obtenerVentasPorVolumen($conn, $vendedores, $fecha_inicio_sql, $fecha_fin_sql) {
    $ventasVolumenData = [];
    while ($vendedor = $vendedores->fetch_assoc()) {
        $vendedorId = $vendedor['rowid'];
        $sqlVolumen = "SELECT DISTINCT 
            y.label AS Categoria, 
            IF(y.label = 'embutidos', 
                SUM(CASE WHEN p.rowid IN ('112', '37', '137', '120', '142') THEN fd.qty ELSE fd.qty * 10 END), 
                SUM(fd.qty)
            ) AS Cantidad 
        FROM llx_facture AS f
        LEFT JOIN llx_facturedet AS fd ON f.rowid = fd.fk_facture
        LEFT JOIN llx_product AS p ON fd.fk_product = p.rowid
        LEFT JOIN llx_categorie_product AS cp ON cp.fk_product = p.rowid
        LEFT JOIN llx_categorie AS y ON y.rowid = cp.fk_categorie
        WHERE f.fk_soc IN (SELECT sc.fk_soc FROM llx_societe_commerciaux AS sc WHERE sc.fk_user = $vendedorId)
        AND f.datef >= '$fecha_inicio_sql'
        AND f.datef <= '$fecha_fin_sql'
        GROUP BY y.label";

        $resqlVolumen = $conn->query($sqlVolumen);
        while ($row = $resqlVolumen->fetch_assoc()) {
            $ventasVolumenData[$vendedor['nombre']][$row['Categoria']] = $row['Cantidad'];
        }
    }
    return $ventasVolumenData;
}


$ventasVolumenRiga = obtenerVentasPorVolumen($local_conn, $vendedores_riga, $fecha_inicio_sql, $fecha_fin_sql);
$ventasVolumenGuayoyo = obtenerVentasPorVolumen($remote_conn, $vendedores_guayoyo, $fecha_inicio_sql, $fecha_fin_sql);



// Convertir datos a JSON
$ventasVolumenJSON_Riga = json_encode($ventasVolumenRiga);
$ventasVolumenJSON_Guayoyo = json_encode($ventasVolumenGuayoyo);
        

        // Calcular el total de ventas para el porcentaje
        $total_facturas_guayoyo = 0;
        $total_cantidad_guayoyo = 0; // Para totalizar cantidad
        while ($row = $guayoyo_result->fetch_assoc()) {
            $total_facturas_guayoyo += $row['TotalFacturas'];
            $total_cantidad_guayoyo += $row['cantidad_clientes']; // Sumar cantidad
        }
        $guayoyo_result->data_seek(0); // Reiniciar el puntero de resultados
   // } else {
   //     $error_message = "No logró autorización. Intente nuevamente.";
 //   }
//} else {
//    $clave = '';
//}
// Cerrar conexiones
$local_conn->close();
$remote_conn->close();
?>


<!DOCTYPE html>
<!DOCTYPE html>
<html lang="es">
<head>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@latest"></script> 
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css">

    <?php
    // Botón de regresar
    echo '<button onclick="history.back()" class="btn-regresar" style="background-color: #ff7f00; color: white; padding: 5px 15px; font-size: 0.8rem; border: none; cursor: pointer;">
        &#8592; Regresar
      </button>';
    ?>  

    <form method="POST" class="mb-4 d-flex align-items-center">
        <div class="me-2">
            <label for="fecha_inicio" class="form-label">Fecha de Inicio:</label>
            <input type="date" id="fecha_inicio" name="fecha_inicio" class="form-control" required>
        </div>
        
        <div class="me-2">
            <label for="fecha_fin" class="form-label">Fecha de Fin:</label>
            <input type="date" id="fecha_fin" name="fecha_fin" class="form-control" required>
        </div>
        
        <button type="submit" class="btn btn-warning d-flex align-items-center">
            <i class="bi bi-funnel-fill me-1"></i> Filtrar
        </button>
       <!-- Botón para quitar filtro -->
    <button type="button" class="btn btn-secondary ms-2" onclick="quitarFiltro()">
        <i class="bi bi-x-circle me-1"></i> Quitar Filtro
    </button>
</form>

<script>
    function quitarFiltro() {
        // Redirigir a la misma página sin parámetros de fecha
        window.location.href = window.location.pathname;
    }
</script>
    
   
    <style>
    
        body {
        margin: 100px;
        padding: 0;
        font-family: Arial, sans-serif; /* Establece una fuente por defecto */
    }
    .container {
        margin: 0 20px; /* Ajusta el margen izquierdo y derecho */
    }
    
    
    form {
    margin: 20px 0; /* Espacio superior e inferior */
}

.btn-warning {
    background-color: #ff9800; /* Color naranja */
    border: none; /* Sin borde */
}

.btn-warning:hover {
    background-color: #e68a00; /* Color naranja más oscuro al pasar el ratón */
}

.form-label {
    font-weight: bold; /* Negrita para las etiquetas */
}
    
    
        .progress-bar {
            height: 10px;
            border-radius: 5px;
        }
        .bar-container {
            background-color: #e0e0e0; /* Color de fondo de la barra */
            border-radius: 5px;
            overflow: hidden;
            height: 10px;
            width: 100%;
        }
        /* Estilos para la tabla RIGA */
        .riga-table {
            background-color: #fff3e0; /* Fondo claro */
        }
        .riga-header {
            background-color: #ff9800; /* Naranja */
            color: white;
        }
        /* Estilos para la tabla GUAYOYO */
        .guayoyo-table {
            background-color: #e3f2fd; /* Fondo claro */
        }
        .guayoyo-header {
            background-color: #2196f3; /* Azul */
            color: white;
        }
        /* Ancho de las columnas */
    .riga-table th:nth-child(1),
    .riga-table td:nth-child(1) {
        width: 30%; /* Ancho para Asesor Comercial */
    }
    .riga-table th:nth-child(2),
    .riga-table td:nth-child(2) {
        width: 20%; /* Ancho para Activación */
    }
    .riga-table th:nth-child(3),
    .riga-table td:nth-child(3) {
        width: 10%; /* Ancho para Cantidad */
    }
    .riga-table th:nth-child(4),
    .riga-table td:nth-child(4) {
        width: 25%; /* Ancho para % del total de venta */
    }
    .guayoyo-table th:nth-child(1),
    .guayoyo-table td:nth-child(1) {
        width: 30%; /* Ancho para Asesor Comercial */
    }
    .guayoyo-table th:nth-child(2),
    .guayoyo-table td:nth-child(2) {
        width: 20%; /* Ancho para Activación */
    }
    .guayoyo-table th:nth-child(3),
    .guayoyo-table td:nth-child(3) {
        width: 10%; /* Ancho para Cantidad */
    }
    .guayoyo-table th:nth-child(4),
    .guayoyo-table td:nth-child(4) {
        width: 25%; /* Ancho para % del total de venta */
    }
    
    
     .chart-wrapper {
            width: 100%;
            height: 500px;
        }
        canvas {
            width: 100% !important; 
            height: 100% !important;
        }
        
        .text-center {
    text-align: center; /* Asegura que el texto esté centrado */
}
    .pt-4 {
    padding-top: 50px; /* Ajusta el valor según sea necesario */
}    
    
    </style>
    </head>
<body>

       <div class="p-6 bg-background text-foreground text-center">
    <img src="logo.png" alt="Logo" class="mb-4" style="max-width: 150px; height: auto; display: block; margin-left: auto; margin-right: auto;">
    <h1 class="text-2xl font-bold mb-4">Seguimiento diario a Vendedores</h1>
    <h2 class="text-xl mb-2">Activación, Venta y Volumen</h2>
    <p class="text-muted-foreground mb-6"><?php echo date('l, d \d\e F \d\e Y'); ?></p>
            <div class="mb-8">
                <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">DISTRIBUIDORARIGA0803,C.A. (Semana en Curso)</h3>
                <table class="min-w-full border-collapse border border-border riga-table">
                    <thead>
                        <tr class="riga-header">
                            <th class="border border-border p-2">Asesor Comercial</th>
                            <th class="border border-border p-2">Activación</th>
                            <th class="border border-border p-2">Cantidad</th>
                            <th class="border border-border p-2">% del total de venta</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $riga_result->fetch_assoc()): ?>
                        <tr>
                            <td class="border border-border p-2"><?php echo $row['nombre']; ?></td>
                            <td class="border border-border p-2">
                                <?php
                                $activacion_porcentaje = ($row['cantidad_clientes'] / $total_cantidad_riga) * 100;
                                echo number_format($row['cantidad_clientes'], 0);
                                ?>
                                <div class="bar-container">
                                    <div class="progress-bar" style="width: <?php echo number_format($activacion_porcentaje, 2); ?>%; background-color: #ff9800;"></div>
                                </div>
                            </td>
                            <td class="border border-border p-2"><?php echo number_format($row['total_ventas'], 2); ?></td>
                            <td class="border border-border p-2">
                                <?php
                                $porcentaje = ($row['total_ventas'] / $total_ventas_riga) * 100;
                                echo number_format($porcentaje, 2) . '%';
                                ?>
                                <div class="bar-container">
                                    <div class="progress-bar" style="width: <?php echo number_format($porcentaje, 2); ?>%; background-color: #ff9800;"></div>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <tr class="font-bold">
                            <td class="border border-border p-2">Total General</td>
                            <td class="border border-border p-2"><?php echo number_format($total_cantidad_riga, 0); ?></td>
                            <td class="border border-border p-2"><?php echo number_format($total_ventas_riga, 2); ?></td>
                            <td class="border border-border p-2">100%</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div>
                <h3 class="text-lg font-semibold bg-secondary text-secondary-foreground p-2">GUAYOYO76,C.A. (Semana en Curso)</h3>
                <table class="min-w-full border-collapse border border-border guayoyo-table">
                    <thead>
                        <tr class="guayoyo-header">
                            <th class="border border-border p-2">Asesor Comercial</th>
                            <th class="border border-border p-2">Activación</th>
                            <th class="border border-border p-2">Cantidad</th>
                            <th class="border border-border p-2">% del total de venta</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($row = $guayoyo_result->fetch_assoc()): ?>
                        <tr>
                            <td class="border border-border p-2"><?php echo $row['nombre']; ?></td>
                            <td class="border border-border p-2">
                                <?php
                                $activacion_porcentaje = ($row['cantidad_clientes'] / $total_cantidad_guayoyo) * 100;
                                echo number_format($row['cantidad_clientes'], 0);
                                ?>
                                <div class="bar-container">
                                    <div class="progress-bar" style="width: <?php echo number_format($activacion_porcentaje, 2); ?>%; background-color: #2196f3;"></div>
                                </div>
                            </td>
                            <td class="border border-border p-2"><?php echo number_format($row['TotalFacturas'], 2); ?></td>
                            <td class="border border-border p-2">
                                <?php
                                $porcentaje = ($row['TotalFacturas'] / $total_facturas_guayoyo) * 100;
                                echo number_format($porcentaje, 2) . '%';
                                ?>
                                <div class="bar-container">
                                    <div class="progress-bar" style="width: <?php echo number_format($porcentaje, 2); ?>%; background-color: #2196f3;"></div>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <tr class="font-bold">
                            <td class="border border-border p-2">Total General</td>
                            <td class="border border-border p-2"><?php echo number_format($total_cantidad_guayoyo, 0); ?></td>
                            <td class="border border-border p-2"><?php echo number_format($total_facturas_guayoyo, 2); ?></td>
                            <td class="border border-border p-2">100%</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
 <!-- Asesores sin Venta en RIGA -->
<div class="mt-8">
    <h3 class="text-lg font-semibold">Asesores sin Venta en RIGA</h3>
    <table class="min-w-full bg-white border border-gray-300 mt-2">
        <thead>
            <tr class="bg-gray-200">
                <th class="py-2 px-4 border-b">Nombre</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $sin_venta_riga_result->fetch_assoc()): ?>
                <tr>
                    <td class="py-2 px-4 border-b"><?php echo $row['nombre']; ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

<!-- Asesores sin Venta en GUAYOYO -->
<div class="mt-8">
    <h3 class="text-lg font-semibold">Asesores sin Venta en Guayoyo</h3>
    <table class="min-w-full bg-white border border-gray-300 mt-2">
        <thead>
            <tr class="bg-gray-200">
                <th class="py-2 px-4 border-b">Nombre</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $sin_venta_guayoyo_result->fetch_assoc()): ?>
                <tr>
                    <td class="py-2 px-4 border-b"><?php echo $row['nombre']; ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>

 
       <div class="row" style="padding-top:50px; text-align:center;">
        <!-- Card para el Gráfico de Ventas por Volumen -->
        <div class="col-md-6" style="padding-bottom:20px;"> <!-- Cambiar a col-md-6 para ocupar el 50% -->
            <div class="border-0 shadow">
                <div class="card-body">
                    <h5>Ventas por Volumen Semana en Curso Riga</h5>
                    <div class="chart-wrapper" style="width: 100%; height: 500px;"> <!-- Mantenemos el ancho al 100% -->
                        <div class="chart-container">
                            <canvas id="ventasRigaChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card para el Gráfico de Ventas y Cobranzas -->
        <div class="col-md-6" style="padding-bottom:20px;"> <!-- Cambiar a col-md-6 para ocupar el 50% -->
            <div class="border-0 shadow">
                <div class="card-body">
                    <h5>Ventas por Volumen Semana en Curso Guayoyo</h5>
                    <div class="chart-wrapper" style="width: 100%; height: 500px;">
                        <div class="chart-container">
                            <canvas id="ventasGuayoyoChart"></canvas> <!-- Cambia el ID según sea necesario -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        const ventasRigaData = <?php echo $ventasVolumenJSON_Riga; ?>;
        const ventasGuayoyoData = <?php echo $ventasVolumenJSON_Guayoyo; ?>;

        function crearGrafico(ctx, data, title) {
            const labels = Object.keys(data);
            const categorias = [...new Set([].concat(...Object.values(data).map(v => Object.keys(v))))];

            const datasets = categorias.map(cat => {
                return {
                    label: cat,
                    data: labels.map(v => data[v][cat] || 0),
                    backgroundColor: getRandomColor(),
                };
            });

            new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: datasets,
                },
                options: {
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                            title: {
                                display: true,
                                text: 'Vendedores'
                            }
                        },
                        y: {
                            stacked: true,
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'Cantidad'
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            position: 'top',
                        }
                    }
                }
            });
        }

        function getRandomColor() {
            const letters = '0123456789ABCDEF';
            let color = '#';
            for (let i = 0; i < 6; i++) {
                color += letters[Math.floor(Math.random() * 16)];
            }
            return color;
        }

        document.addEventListener('DOMContentLoaded', function () {
            const ctxRiga = document.getElementById('ventasRigaChart').getContext('2d');
            crearGrafico(ctxRiga, ventasRigaData, 'Ventas por Volumen RIGA');

            const ctxGuayoyo = document.getElementById('ventasGuayoyoChart').getContext('2d');
            crearGrafico(ctxGuayoyo, ventasGuayoyoData, 'Ventas por Volumen GUAYOYO');
        });
    </script>
       
</body>
</html>

