<?php
require 'conexion.php'; // Incluye el archivo de conexión

// Verificar si los campos necesarios están definidos en $_POST
if (!isset($_POST['Corigen'])) {
    die("Error: No se proporcionó el ID del pedido.");
}

// Variables del formulario
$Corigen = $_POST['Corigen']; // ID del pedido
$vendedorNombre = 'Nombre del Vendedor'; // Este valor debería venir de otro formulario o sesión
$vendedorId = 1; // Este valor debería venir de otro formulario o sesión

// Consulta para obtener los detalles del pedido
$sql = "SELECT DISTINCT 
            s.nom AS Cliente, 
            c.ref AS Ref_Pedido, 
            c.date_creation AS Fecha_Creacion, 
            p.rowid AS id_producto, 
            p.label AS Producto, 
            cd.description AS descripcion, 
            cd.qty AS Cantidad, 
            u.nom_unidad AS Tipo_despacho, 
            extra2.cantidad_despacho AS Cantidad_Despacho
        FROM 
            llx_societe AS s 
        INNER JOIN 
            llx_commande AS c ON c.fk_soc = s.rowid
        INNER JOIN 
            llx_commandedet AS cd ON c.rowid = cd.fk_commande
        LEFT JOIN 
            llx_projet AS pj ON c.fk_projet = pj.rowid
        LEFT JOIN 
            llx_user AS uc ON c.fk_user_author = uc.rowid
        LEFT JOIN 
            llx_user AS uv ON c.fk_user_valid = uv.rowid
        LEFT JOIN 
            llx_commande_extrafields AS extra ON c.rowid = extra.fk_object
        LEFT JOIN 
            llx_commandedet_extrafields AS extra2 ON cd.rowid = extra2.fk_object
        LEFT JOIN 
            llx_udd AS u ON extra2.cestas = u.cod_unidad
        LEFT JOIN 
            llx_product AS p ON cd.fk_product = p.rowid
        LEFT JOIN 
            llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object
        WHERE
			c.fk_statut = 1
            AND c.rowid = '$Corigen'"; // Usamos el ID del pedido obtenido

$result = $conn->query($sql);

// Iniciar el HTML con estilos y animaciones
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Resultado del Despacho</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Animación de escritura */
        @keyframes typing {
            from { width: 0; }
            to { width: 100%; }
        }
        @keyframes blink-caret {
            from, to { border-color: transparent; }
            50% { border-color: #007bff; }
        }
        .typewriter {
            overflow: hidden; /* Oculta el texto que se desborda */
            border-right: 2px solid #007bff; /* Efecto de cursor */
            white-space: nowrap; /* Evita saltos de línea */
            margin: 0 auto;
            letter-spacing: 0.15em; /* Espaciado entre letras */
            animation: typing 3s steps(40, end), blink-caret 0.75s step-end infinite;
        }
        .response-message {
            background-color: #f8f9fa;
            border-left: 5px solid #007bff;
            padding: 15px;
            margin-bottom: 10px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            opacity: 0; /* Inicialmente invisible */
            animation: fadeIn 0.5s ease-out forwards; /* Animación de aparición */
        }
        @keyframes fadeIn {
            to { opacity: 1; }
        }
        .hidden {
            display: none; /* Oculta el botón hasta que termine la animación */
        }
    </style>
</head>
<body>
    <div>
        <div class="row justify-content-center">
            <div class="col-md-8">
                <?php
                if ($result->num_rows > 0) {
                    // Iterar sobre cada línea del pedido
                    while ($row = $result->fetch_assoc()) {
                        $Pcantidad = $row['Cantidad']; // Cantidad del producto actual
                        $Prowid = $row['id_producto']; // ID del producto actual
                        $CantidadDespacho = $row['Cantidad_Despacho']; // Cantidad de despacho (cestas)

                        // Insertar en llx_despacho_nuevo
                        $sqlInsert = "INSERT INTO llx_despacho_nuevo (cliente, ref_pedido, fecha_creacion, producto, descripcion, cantidad, tipo_despacho, cantidad_despacho, usuario_sistema)
                                      VALUES ('" . $row['Cliente'] . "', '$Corigen', NOW(), '" . $row['Producto'] . "', '" . $row['descripcion'] . "', $Pcantidad, '" . $row['Tipo_despacho'] . "', $CantidadDespacho, '$vendedorNombre')";
                        if ($conn->query($sqlInsert) === TRUE) {
                            echo '<div class="response-message typewriter">✅ Registro insertado correctamente en <strong>llx_despacho_nuevo</strong> para el producto: ' . $row['Producto'] . '</div>';
                        } else {
                            echo '<div class="response-message typewriter">❌ Error al insertar en <strong>llx_despacho_nuevo</strong>: ' . $conn->error . '</div>';
                        }

                        // Update llx_product_stock
                        $sqlUpdateStock = "UPDATE llx_product_stock SET reel = reel - $Pcantidad WHERE fk_product = $Prowid AND fk_entrepot = 4";
                        if ($conn->query($sqlUpdateStock) === TRUE) {
                            echo '<div class="response-message typewriter">✅ Stock actualizado correctamente en <strong>llx_product_stock</strong> para el producto: ' . $row['Producto'] . '</div>';
                        } else {
                            echo '<div class="response-message typewriter">❌ Error al actualizar <strong>llx_product_stock</strong>: ' . $conn->error . '</div>';
                        }

                        // Update llx_product
                        $sqlUpdateProduct = "UPDATE llx_product SET stock = stock - $Pcantidad WHERE rowid = $Prowid";
                        if ($conn->query($sqlUpdateProduct) === TRUE) {
                            echo '<div class="response-message typewriter">✅ Stock actualizado correctamente en <strong>llx_product</strong> para el producto: ' . $row['Producto'] . '</div>';
                        } else {
                            echo '<div class="response-message typewriter">❌ Error al actualizar <strong>llx_product</strong>: ' . $conn->error . '</div>';
                        }

                        // Insertar en llx_stock_mouvement
                        $sqlInsertMov = "INSERT INTO llx_stock_mouvement (fk_product, tms, datem, value, fk_entrepot, fk_user_author, label, type_mouvement, fk_origin, origintype)
                                         VALUES ($Prowid, NOW(), NOW(), -$Pcantidad, 4, $vendedorId, 'Expedición por salida de producto del almacén', 2, '$Corigen', 'commande')";
                        if ($conn->query($sqlInsertMov) === TRUE) {
                            echo '<div class="response-message typewriter">✅ Movimiento insertado correctamente en <strong>llx_stock_mouvement</strong> para el producto: ' . $row['Producto'] . '</div>';
                        } else {
                            echo '<div class="response-message typewriter">❌ Error al insertar en <strong>llx_stock_mouvement</strong>: ' . $conn->error . '</div>';
                        }
                    }

                    // Actualizar el estado del pedido en llx_commande
                    $sqlUpdateCommande = "UPDATE llx_commande SET fk_statut = '3' WHERE rowid = '$Corigen'";
                    if ($conn->query($sqlUpdateCommande) === TRUE) {
                        echo '<div class="response-message typewriter">✅ Estado del pedido actualizado correctamente en <strong>llx_commande</strong>.</div>';
                    } else {
                        echo '<div class="response-message typewriter">❌ Error al actualizar el estado del pedido en <strong>llx_commande</strong>: ' . $conn->error . '</div>';
                    }

                    echo '<div class="response-message typewriter">🎉 Despacho realizado con éxito para todas las líneas del pedido.</div>';
                } else {
                    echo '<div class="response-message typewriter">❌ No se encontraron líneas para el pedido: ' . $Corigen . '</div>';
                }
                ?>

                <!-- Botón para regresar al formulario anterior (oculto inicialmente) -->
                <div id="returnButton" class="text-center mt-4 hidden">
                    <a href="formulario_despacho.php" class="btn btn-primary">Regresar al Formulario</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Mostrar el botón de regreso después de que todas las animaciones terminen
        setTimeout(() => {
            document.getElementById('returnButton').classList.remove('hidden');
        }, 3000); // Ajusta el tiempo según la duración de las animaciones
    </script>
</body>
</html>

<?php
// Cerrar la conexión
$conn->close();
?>