<?php
include_once DOL_DOCUMENT_ROOT.'/core/modules/DolibarrModules.class.php';

class modCalificacioncrediticia extends DolibarrModules
{
    function __construct($db)
    {
        $this->db = $db;
        $this->numero = 104997;
        $this->rights_class = 'calificacioncrediticia';
        $this->family = 'crm';
        $this->name = 'calificacioncrediticia';
        $this->description = 'Calificación Crediticia (Premium/Estandar/EnAtencion/AltoRiesgo)';
        $this->version = '1.0';
        $this->const_name = 'MAIN_MODULE_CALIFICACIONCREDITICIA';
        $this->picto='technic';

        $this->module_parts = array('triggers'=>1,
        'hooks' => array('thirdpartycard', 'invoicelist', 'thirdpartylist'),
        'js'  => array('/calificacioncrediticia/js/cc_badge.js'),   // <-- JS que inyecta la insignia
        'css' => array('/calificacioncrediticia/css/cc_badge.css'),); // <-- estilos (opcional));
        $this->config_page_url = array('setup.php@calificacioncrediticia');
        $this->need_dolibarr_version = array(11,0);
        $this->langfiles = array('calificacioncrediticia@calificacioncrediticia');

        $this->tabs = array(
            'thirdparty:+calificacioncrediticia:Calificación Crediticia:calificacioncrediticia@calificacioncrediticia:/calificacioncrediticia/thirdparty_tab.php?id=__ID__'
        );

        $this->const = array(
            array('CC_W_DSO','chaine','0.25','Peso DSO',1,'current',0),
            array('CC_W_CASH','chaine','0.20','Peso %Contado',1,'current',0),
            array('CC_W_OVERDUE','chaine','0.15','Peso Morosidad',1,'current',0),
            array('CC_W_MARGIN','chaine','0.00','Peso Margen (0 si no usas)',1,'current',0),
            array('CC_W_SALES','chaine','0.05','Peso Ventas mensuales',1,'current',0),
            array('CC_W_TENURE','chaine','0.10','Peso Antigüedad/Frecuencia',1,'current',0),
            array('CC_W_RETURNS','chaine','0.05','Peso Devoluciones',1,'current',0),
            array('CC_W_EVENTS','chaine','0.00','Peso Eventos críticos',1,'current',0),

            array('CC_THR_PREMIUM','chaine','85','Umbral Premium',1,'current',0),
            array('CC_THR_ESTANDAR','chaine','70','Umbral Estandar',1,'current',0),
            array('CC_THR_ENATENCION','chaine','55','Umbral EnAtencion',1,'current',0),

            array('CC_VETO_MAXOVERDUEDAYS','chaine','45','Veto: días vencidos máximos',1,'current',0),
            array('CC_VETO_BOUNCED_365','chaine','2','Veto cheques 365d',1,'current',0),
            array('CC_VETO_BOUNCED_180','chaine','1','Veto cheques 180d',1,'current',0),

            array('CC_AUTO_RENORM','chaine','1','Auto-reponderación (0/1)',1,'current',0),
            array('CC_EVENTS_MODE','chaine','MANUAL','Eventos: MANUAL|AUTO|HYBRID',1,'current',0),
            array('CC_EVENTS_LABELS','chaine','DEVUELTO,RECHAZADO','Patrones banco',1,'current',0),
        );
    }
    function init($o=''){ $sql=array(); return $this->_init($sql,$o); }
    function remove($o=''){ $sql=array(); return $this->_remove($sql,$o); }
}
