<?php
require 'conexion.php'; // Incluye el archivo de conexión

// Variables para almacenar los datos del pedido
$Pcantidad = $Prowid = $Corigen = '';
$vendedorNombre = 'Nombre del Vendedor'; // Este valor debería venir de otro formulario o sesión
$vendedorId = 1; // Este valor debería venir de otro formulario o sesión

// Inicializa la variable $id_factura
$id_factura = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_factura'])) {
    $id_factura = $_POST['id_factura'];

    // Consulta SQL para obtener los detalles del pedido
    $sql = "SELECT DISTINCT 
                s.nom AS Cliente, 
                c.rowid AS id_pedido, 
                c.ref AS Ref_Pedido, 
                c.date_creation AS Fecha_Creacion, 
                p.rowid AS id_producto, 
                p.label AS Producto, 
                cd.description AS descripcion, 
                cd.qty AS Cantidad, 
                u.nom_unidad AS Tipo_despacho, 
                extra2.cantidad_despacho AS Cantidad_Despacho
            FROM 
                llx_element_element AS ee
            INNER JOIN 
                llx_commande AS c ON ee.fk_source = c.rowid
            INNER JOIN 
                llx_societe AS s ON c.fk_soc = s.rowid
            INNER JOIN 
                llx_commandedet AS cd ON c.rowid = cd.fk_commande
            LEFT JOIN 
                llx_projet AS pj ON c.fk_projet = pj.rowid
            LEFT JOIN 
                llx_user AS uc ON c.fk_user_author = uc.rowid
            LEFT JOIN 
                llx_user AS uv ON c.fk_user_valid = uv.rowid
            LEFT JOIN 
                llx_commande_extrafields AS extra ON c.rowid = extra.fk_object
            LEFT JOIN 
                llx_commandedet_extrafields AS extra2 ON cd.rowid = extra2.fk_object
            LEFT JOIN 
                llx_udd AS u ON extra2.cestas = u.cod_unidad
            LEFT JOIN 
                llx_product AS p ON cd.fk_product = p.rowid
            LEFT JOIN 
                llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object
            WHERE 
                ee.fk_target = '$id_factura'
                AND ee.targettype = 'facture'
                AND c.entity IN (1)
                AND c.fk_statut = 1";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Asignar valores a las variables (solo para la primera fila)
        $row = $result->fetch_assoc();
        $Pcantidad = $row['Cantidad'];
        $Prowid = $row['id_producto'];
        $Corigen = $row['id_pedido'];

        // Reiniciar el puntero del resultado para iterar desde el principio
        $result->data_seek(0);
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Despacho de Productos</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .logo { width: 150px; margin-bottom: 20px; }
        .title { font-family: 'Arial', sans-serif; font-size: 28px; margin-bottom: 30px; }
        .form-container { background-color: #f8f9fa; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        .btn-custom { background-color: #007bff; border-color: #007bff; color: white; }
        .btn-custom:hover { background-color: #0056b3; border-color: #004085; }
        .table-custom { margin-top: 20px; }
        .alert-custom { margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 text-center">
                <img src="logo.png" alt="Logo" class="logo">
                <h1 class="title">Despacho de Productos</h1>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-8 form-container">
                <form method="post">
                    <div class="form-group">
                        <label for="id_factura">ID de la Factura:</label>
                        <input type="text" class="form-control" id="id_factura" name="id_factura" required>
                    </div>
                    <button type="submit" class="btn btn-custom btn-block">Buscar Pedido</button>
                </form>
            </div>
        </div>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_factura']) && $result->num_rows > 0): ?>
            <div class="row justify-content-center">
                <div>
                    <div class="table-responsive table-custom">
                        <table class="table table-bordered">
                            <thead class="thead-light">
                                <tr>
                                    <th>Cliente</th>
                                    <th>Referencia Pedido</th>
                                    <th>Fecha Creación</th>
                                    <th>Producto</th>
                                    <th>Descripción</th>
                                    <th>Cantidad</th>
                                    <th>Tipo Despacho</th>
                                    <th>Cantidad Despacho</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while($row = $result->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $row['Cliente']; ?></td>
                                        <td><?php echo $row['Ref_Pedido']; ?></td>
                                        <td><?php echo $row['Fecha_Creacion']; ?></td>
                                        <td><?php echo $row['Producto']; ?></td>
                                        <td><?php echo $row['descripcion']; ?></td>
                                        <td><?php echo $row['Cantidad']; ?></td>
                                        <td><?php echo $row['Tipo_despacho']; ?></td>
                                        <td><?php echo $row['Cantidad_Despacho']; ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <form method="post" action="despachar.php">
                        <input type="hidden" name="Corigen" value="<?php echo $Corigen; ?>">
                        <button type="submit" class="btn btn-success btn-block">Despachar</button>
                    </form>
                </div>
            </div>
        <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['id_factura']) && $result->num_rows == 0): ?>
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="alert alert-warning alert-custom mt-3" role="alert">
                        No se encontraron resultados para el ID de la factura o el pedido no tiene el status correcto: <?php echo htmlspecialchars($id_factura); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>