<?php
// Conexión a la base de datos
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

// Verifica si la conexión fue exitosa
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

// Consulta para obtener todos los vendedores
$query = $mysqli->query("SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre 
                          FROM llx_user as u 
                          LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user
                          WHERE u.statut = 1
                          AND u.firstname != ''
                          AND us.fk_usergroup = 1");

// Inicializa un array para almacenar los datos de los vendedores
$vendedoresData = [];

// Verifica si la consulta devolvió resultados
if ($query->num_rows > 0) {
    while ($valores = mysqli_fetch_array($query)) {
        // ID del vendedor actual
        $vendedorId = $valores['rowid'];

        // TOTAL DE CLIENTES DEL VENDEDOR 
        $sql = 'SELECT COUNT(DISTINCT s.rowid) AS Total_Clientes
                FROM llx_societe AS s 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                WHERE s.entity IN (1) AND s.status = 1 AND u.rowid = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $clientesVendedor = $resql ? $resql->fetch_object()->Total_Clientes : 0;

        // CLIENTES CON FACTURAS PENDIENTES POR PAGO  
        $sql = 'SELECT COUNT(DISTINCT f.rowid) AS Total_Facturas
                FROM llx_societe AS s 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                LEFT JOIN llx_facture AS f ON f.fk_soc = s.rowid 
                WHERE f.fk_statut = 1 AND f.entity IN (1) AND u.rowid = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $facturasPendientes = $resql ? $resql->fetch_object()->Total_Facturas : 0;

        // CLIENTES QUE NO SE HAN ACTIVADO POR VENDEDOR   
        $sql = 'SELECT COUNT(DISTINCT s.nom) AS ClientesNoactivos
                FROM llx_societe AS s
                LEFT JOIN llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
                LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                WHERE u.rowid = ' . $vendedorId . ' AND s.status = 1
                AND s.nom NOT IN (
                    SELECT DISTINCT s.nom 
                    FROM llx_societe AS s 
                    LEFT JOIN llx_facture AS f ON s.rowid = f.fk_soc 
                    LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
                    LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
                    WHERE f.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
                    AND u.rowid = ' . $vendedorId . ')';

        $resql = $mysqli->query($sql);
        $ClientesNoactivos = $resql ? $resql->fetch_object()->ClientesNoactivos : 0;

        // TOTAL VISITAS PROGRAMADAS PARA EL DIA 
        $sql = 'SELECT COUNT(*) AS VisitasProgramadas
                FROM llx_planificacion_programa AS p 
                WHERE p.status = 0 
                AND DATE(p.fecha_visita) = CURDATE()
                AND p.fk_user_creat = ' . $vendedorId;

        $resql = $mysqli->query($sql);
        $VisitasProgramadas = $resql ? $resql->fetch_object()->VisitasProgramadas : 0;

        // Almacena los datos del vendedor en el array
        $vendedoresData[] = [
            'rowid' => $vendedorId,
            'nombre' => $valores['nombre'],
            'clientes' => $clientesVendedor,
            'facturas' => $facturasPendientes,
            'noactivos' => $ClientesNoactivos,
            'visitas' => $VisitasProgramadas
        ];
    }
}

// Consultar Ventas por Volumen
$ventasVolumenData = [];
foreach ($vendedoresData as $vendedor) {
    $vendedorId = $vendedor['rowid']; // Asumiendo que el array tiene la clave 'rowid'
    
    // Mantener la conexión abierta
    $sqlVolumen = 'SELECT DISTINCT 
        y.label AS Categoria, 
        IF(y.label = "embutidos", 
            SUM(CASE WHEN p.rowid IN ("112", "37") THEN fd.qty ELSE fd.qty * 10 END), 
            SUM(fd.qty)
        ) AS Cantidad 
    FROM 
        llx_societe AS s 
    LEFT JOIN 
        llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
    LEFT JOIN 
        llx_user AS u ON sc.fk_user = u.rowid 
    LEFT JOIN 
        llx_facture AS f ON f.fk_soc = s.rowid 
    LEFT JOIN 
        llx_facturedet AS fd ON f.rowid = fd.fk_facture 
    LEFT JOIN 
        llx_facture_extrafields AS extra ON f.rowid = extra.fk_object 
    LEFT JOIN 
        llx_facturedet_extrafields AS extra2 ON fd.rowid = extra2.fk_object 
    LEFT JOIN 
        llx_product AS p ON fd.fk_product = p.rowid 
    LEFT JOIN 
        llx_product_extrafields AS extra3 ON p.rowid = extra3.fk_object 
    LEFT JOIN 
        llx_categorie_product AS cp ON cp.fk_product = p.rowid 
    LEFT JOIN 
        llx_categorie AS y ON y.rowid = cp.fk_categorie 
    WHERE 
        u.rowid = ' . $vendedorId . ' 
        AND f.datef >= CURDATE() - INTERVAL WEEKDAY(CURDATE()) DAY 
        AND f.datef < CURDATE() + INTERVAL (7 - WEEKDAY(CURDATE())) DAY 
    GROUP BY 
        Categoria 
    ORDER BY 
        Categoria';

    $resqlVolumen = $mysqli->query($sqlVolumen);
    if ($resqlVolumen) {
        while ($row = $resqlVolumen->fetch_object()) {
            // Asegúrate de inicializar la categoría si no existe
            if (!isset($ventasVolumenData[$vendedorId])) {
                $ventasVolumenData[$vendedorId] = [];
            }
            $ventasVolumenData[$vendedorId][$row->Categoria] = $row->Cantidad;
        }
    }
}

// Convertir datos a JSON
$ventasVolumenJSON = json_encode($ventasVolumenData);

// Cierra la conexión
$mysqli->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Principal</title>

  <!-- Vincula Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
        font-size: 0.85rem; /* Tamaño de texto más pequeño */
        padding-left: 250px;
        padding-top: 10px;
        margin: 0; /* Margen global */
    }

    .carousel-inner {
      padding: 2em 0;
    }

    .card {
      min-height: 360px;
      max-width: 250px;
      margin: 0 10px; /* Espacio entre tarjetas */
    }

    .d-flex {
      display: flex;
      justify-content: center;
      align-items: center;
      gap: 15px; /* Espacio entre las cartas */
    }

    /* Estilos para el contenedor del gráfico */
    .chart-container {
      position: relative;
      margin: auto;
      height: 280px; /* Altura ajustada */
      width: 100%; /* Ancho completo */
    }

    /* Estilos específicos para el gráfico */
    canvas {
      width: 100% !important; 
      height: 100% !important;
    }
  </style>
</head>
<body>
    <div class="container mt-4">
      <h2>Bienvenido, (Supervisor Formulario en Construcción)</h2>
    </div>

    <div class="row">
      <!-- Carrusel con tarjetas -->
      <?php if (!empty($vendedoresData)): ?>
        <div id="carouselExampleControls" class="carousel slide" data-bs-ride="false">
          <div class="carousel-inner">
            <?php
            // Inicializa la primera tarjeta como activa
            $active = true;
            $itemCount = 0; // Contador para las tarjetas

            foreach ($vendedoresData as $data) {
                // Inicia un nuevo item de carrusel cada 5 tarjetas
                if ($itemCount % 5 == 0) {
                    if ($itemCount > 0) {
                        echo '</div>'; // Cierra el d-flex de tarjetas
                        echo '</div>'; // Cierra el carousel-item anterior
                    }
                    // Aquí se crea un nuevo carousel-item
                    echo '<div class="carousel-item '.($active ? 'active' : '').'">';
                    $active = false; // Desactiva el estado activo después del primer ítem
                    echo '<div class="d-flex">'; // Comienza el contenedor de tarjetas
                }

                // Muestra la tarjeta
                echo '<div class="card">';
                echo '<div class="card-body text-center">';
                echo '<h5 class="card-title">'.$data['nombre'].'</h5>'; // Nombre del vendedor
                echo '<p class="text-muted" style="font-weight: normal;">Zona: Guatire</p>'; // Zona
                echo '<p class="card-text">';
                echo '<strong>Total Clientes:</strong> '.$data['clientes'].'<br>';
                echo '<strong>Facturas Pendientes:</strong> '.$data['facturas'].'<br>';
                echo '<strong>Clientes No Activos:</strong> '.$data['noactivos'].'<br>';
                echo '<strong>Visitas Programadas:</strong> '.$data['visitas'].'<br>';
                echo '</p>';
                echo '<a href="#" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                echo '</div>'; // Cierra card-body
                echo '</div>'; // Cierra card

                $itemCount++; // Incrementa el contador de tarjetas
            }

            // Cierra el último d-flex y carousel-item después del bucle
            if ($itemCount > 0) {
                echo '</div>'; // Cierra el d-flex de tarjetas
                echo '</div>'; // Cierra el carousel-item
            }

            // Botones de navegación del carrusel
            echo '<button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">';
            echo '<span class="carousel-control-prev-icon" aria-hidden="true"></span>';
            echo '<span class="visually-hidden">Previous</span>';
            echo '</button>';
            echo '<button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">';
            echo '<span class="carousel-control-next-icon" aria-hidden="true"></span>';
            echo '<span class="visually-hidden">Next</span>';
            echo '</button>';

            echo '</div>'; // Cierra carousel
            ?>
          </div>
        </div>
      <?php else: ?>
        <p>No hay usuarios disponibles.</p>
      <?php endif; ?>
    </div>

    <div class="row" style="padding-top:20px; text-align:center;">
      <!-- Card para el Gráfico de Ventas por Volumen -->
      <div class="col-md-12" style="padding-bottom:20px;">
        <div class="card border-0 shadow">
          <div class="card-body">
            <h5>Ventas por Volumen de Cada Vendedor</h5>
            <div class="chart-container">
              <canvas id="salesBarChart"></canvas>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Asegúrate de incluir Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
      // Esperamos que el DOM esté completamente cargado
      document.addEventListener('DOMContentLoaded', function () {
        // Datos del gráfico de ventas por volumen
        const ventasVolumenData = <?php echo $ventasVolumenJSON; ?>;

        // Comprobación de datos
        console.log(ventasVolumenData); // Verifica los datos

        const vendedores = Object.keys(ventasVolumenData);
        // Comprobar si hay vendedores disponibles
        if (vendedores.length === 0) {
          console.error("No hay vendedores disponibles.");
          return; // Salir si no hay datos
        }

        const categorias = [...new Set([].concat(...Object.values(ventasVolumenData).map(v => Object.keys(v))))];
        // Comprobar si hay categorías disponibles
        if (categorias.length === 0) {
          console.error("No hay categorías disponibles.");
          return; // Salir si no hay categorías
        }

        const datasets = categorias.map(cat => {
          return {
            label: cat,
            data: vendedores.map(v => ventasVolumenData[v][cat] || 0), // Asignar valores o 0 si no hay datos
            backgroundColor: getRandomColor(), // Asigna un color aleatorio
            borderWidth: 1
          };
        });

        // Función para generar colores aleatorios
        function getRandomColor() {
          const letters = '0123456789ABCDEF';
          let color = '#';
          for (let i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
          }
          return color;
        }

        // Gráfico de Ventas por Volumen (Gráfico de Barras Apiladas)
        var ctxBar = document.getElementById('salesBarChart').getContext('2d');
        var salesBarChart = new Chart(ctxBar, {
          type: 'bar',
          data: {
            labels: vendedores,
            datasets: datasets
          },
          options: {
            responsive: true,
            scales: {
              x: {
                stacked: true,
                grid: { display: false }
              },
              y: {
                stacked: true,
                beginAtZero: true,
                grid: { display: false }
              }
            },
            plugins: {
              legend: {
                position: 'top',
              }
            }
          }
        });
      });
    </script>

    <!-- Vincula Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
