<?php
// Conexión a la base de datos
$mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

// Verifica si la conexión fue exitosa
if ($mysqli->connect_error) {
    die("Conexión fallida: " . $mysqli->connect_error);
}

// ID del vendedor (asegúrate de definir esta variable)
$vendedorId = 1; // Cambia esto según sea necesario

// TOTAL DE CLIENTES DEL VENDEDOR 
$sql = 'SELECT COUNT(DISTINCT s.rowid) AS Total_Clientes
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
WHERE 
    s.entity IN (1)
    AND s.status = 1
    AND u.rowid = ' . $vendedorId;

$resql = $mysqli->query($sql);

if ($resql) {
    $res = $resql->fetch_object();
    $clientesVendedor = $res->Total_Clientes;
} else {
    $clientesVendedor = 0; // Manejo de error
}

// CLIENTES CON FACTURAS PENDIENTES POR PAGO  
$sql = 'SELECT COUNT(DISTINCT f.rowid) AS Total_Facturas
FROM 
    llx_societe AS s 
LEFT JOIN 
    llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN 
    llx_user AS u ON sc.fk_user = u.rowid 
LEFT JOIN 
    llx_facture AS f ON f.fk_soc = s.rowid 
WHERE 
     f.fk_statut = 1 
    AND f.entity IN (1) 
    AND u.rowid = ' . $vendedorId;

$resql = $mysqli->query($sql);

if ($resql) {
    $res = $resql->fetch_object();
    $facturasPendientes = $res->Total_Facturas;
} else {
    $facturasPendientes = 0; // Manejo de error
}

// CLIENTES QUE NO SE HAN ACTIVADO POR VENDEDOR   
$sql = 'SELECT COUNT(DISTINCT s.nom) AS ClientesNoactivos
FROM llx_societe AS s
LEFT JOIN llx_societe_extrafields AS extra ON s.rowid = extra.fk_object 
LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
WHERE 1 = 1
  AND u.rowid = ' . $vendedorId . '
  AND s.status = 1
  AND s.nom NOT IN (
      SELECT DISTINCT s.nom 
      FROM llx_societe AS s 
      LEFT JOIN llx_facture AS f ON s.rowid = f.fk_soc 
      LEFT JOIN llx_societe_commerciaux AS sc ON sc.fk_soc = s.rowid 
      LEFT JOIN llx_user AS u ON sc.fk_user = u.rowid 
      WHERE 1 = 1
        AND f.datef BETWEEN DATE_SUB(CURDATE(), INTERVAL 1 MONTH) AND CURDATE()
        AND u.rowid = ' . $vendedorId . ')';

$resql = $mysqli->query($sql);

if ($resql) {
    $res = $resql->fetch_object();
    $ClientesNoactivos = $res->ClientesNoactivos;
} else {
    $ClientesNoactivos = 0; // Manejo de error
}

// TOTAL VISITAS PROGRAMADAS PARA EL DIA 
$sql = 'SELECT 
    COUNT(*) AS VisitasProgramadas
FROM 
    llx_planificacion_programa AS p 
WHERE 
    p.status = 0 
    AND DATE(p.fecha_visita) = CURDATE()
    AND p.fk_user_creat = ' . $vendedorId;

$resql = $mysqli->query($sql);

if ($resql) {
    $res = $resql->fetch_object();
    $VisitasProgramadas = $res->VisitasProgramadas;
} else {
    $VisitasProgramadas = 0; // Manejo de error
}

// Cierra la conexión
$mysqli->close();
?>



<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Principal</title>

  <!-- Vincula Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="style.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">

  <style>
    body {
        font-size: 0.85rem; /* Tamaño de texto más pequeño */
        padding-left: 250px;
        padding-top: 10px;
        margin: 0; /* Margen global */
    }

    .carousel-inner {
      padding: 2em 0;
    }

    .card {
      min-height: 360px;
      max-width: 250px;
      margin: 0 10px; /* Espacio entre tarjetas */
    }

    .d-flex {
      display: flex;
      justify-content: center;
      align-items: center;
      gap: 15px; /* Espacio entre las cartas */
    }
	
	/* Estilos para los botones de navegación */
    .carousel-control-prev, .carousel-control-next {
      background-color: rgba(0, 0, 0, 0.5); /* Fondo semi-transparente */
      border-radius: 50%; /* Bordes redondeados */
      width: 40px; /* Ancho del botón */
      height: 40px; /* Alto del botón */
    }

    .carousel-control-prev-icon, .carousel-control-next-icon {
      background-color: black; /* Color de la flecha */
      border-radius: 50%; /* Bordes redondeados para la flecha */
    }

    .carousel-control-prev:hover, .carousel-control-next:hover {
      background-color: rgba(0, 0, 0, 0.8); /* Fondo más oscuro al pasar el cursor */
    }
  </style>
</head>
<body>
    <div class="container mt-4">
      <h2>Bienvenido, (Supervisor Formulario en Construcción)</h2>
    </div>

    <div class="row">
      <!-- Carrusel con tarjetas -->
      <?php
        //$mysqli = new mysqli('localhost', 'root', 'pluton007$', 'sistema');
        $mysqli = new mysqli('localhost', 'aliment5_root', 'pluton007$', 'aliment5_doli2');

        // Verifica si la conexión fue exitosa
        if ($mysqli->connect_error) {
            die("Conexión fallida: " . $mysqli->connect_error);
        }

        $query = $mysqli->query("SELECT u.rowid as rowid, CONCAT(u.firstname, ' ', u.lastname) as nombre 
                                  FROM llx_user as u 
                                  LEFT JOIN llx_usergroup_user as us ON u.rowid = us.fk_user
                                  WHERE u.statut = 1
                                  AND u.firstname != ''
                                  AND us.fk_usergroup = 1");

        // Verifica si la consulta devolvió resultados
        if ($query->num_rows > 0) {
            echo '<div id="carouselExampleControls" class="carousel slide" data-bs-ride="false">';
            echo '<div class="carousel-inner">';

            // Inicializa la primera tarjeta como activa
            $active = true;
            $itemCount = 0; // Contador para las tarjetas

            while ($valores = mysqli_fetch_array($query)) {
                // Inicia un nuevo item de carrusel cada 4 tarjetas
                if ($itemCount % 5 == 0) {
                    if ($itemCount > 0) {
                        echo '</div>'; // Cierra el d-flex de tarjetas
                        echo '</div>'; // Cierra el carousel-item anterior
                    }
                    // Aquí se crea un nuevo carousel-item
                    echo '<div class="carousel-item '.($active ? 'active' : '').'">';
                    $active = false; // Desactiva el estado activo después del primer ítem
                    echo '<div class="d-flex">'; // Comienza el contenedor de tarjetas
                }

                // Muestra la tarjeta
                echo '<div class="card">';
                echo '<div class="card-body text-center">';
                echo '<h5 class="card-title">'.$valores['nombre'].'</h5>'; // Nombre del vendedor
                echo '<p class="text-muted" style="font-weight: normal;">Zona: Guatire</p>'; // Zona
                echo '<p class="card-text">';
                echo '<span class="badge" style="font-size: 1.2em; font-weight: bold; background-color: #28a745;">85% <i class="bi bi-arrow-up-circle-fill"></i></span>';
                echo '</p>';
                echo '<p><strong>Volumen de Venta</strong></p>';
                echo '<p>';
                echo '<strong>Pollo:</strong> 520 kg <br>';
                echo '<strong>Huevo:</strong> 300 uds <br>';
                echo '<strong>Embutidos:</strong> 300 uds <br>';
                echo '<strong>Cocidos rebanables:</strong> 250 kg <br>';
                echo '<strong>Viveres:</strong> 100 uds';
                echo '</p>';
                echo '<p>Activaciones: <strong class="text-primary">15</strong> / <span class="text-muted">100</span></p>';
                echo '<a href="#" class="btn" style="background-color: #ff7f00; color: white; padding: 3px 10px; font-size: 0.8rem;">Ver desempeño</a>';
                echo '</div>'; // Cierra card-body
                echo '</div>'; // Cierra card

                $itemCount++; // Incrementa el contador de tarjetas
            }

            // Cierra el último d-flex y carousel-item después del bucle
            if ($itemCount > 0) {
                echo '</div>'; // Cierra el d-flex de tarjetas
                echo '</div>'; // Cierra el carousel-item
            }

            // Botones de navegación del carrusel
            echo '<button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev">';
            echo '<span class="carousel-control-prev-icon" aria-hidden="true"></span>';
            echo '<span class="visually-hidden">Previous</span>';
            echo '</button>';
            echo '<button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next">';
            echo '<span class="carousel-control-next-icon" aria-hidden="true"></span>';
            echo '<span class="visually-hidden">Next</span>';
            echo '</button>';

            echo '</div>'; // Cierra carousel
        } else {
            echo '<p>No hay usuarios disponibles.</p>';
        }

        // Cierra la conexión
        $mysqli->close();
      ?>
    </div>

    <!-- Vincula Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
