<?php
// thirdparty_tab.php

// 1) Núcleo Dolibarr (desde custom/calificacioncrediticia sube 2 niveles a htdocs/)
require '../../main.inc.php';

// 2) Librerías necesarias (prueba ambas ubicaciones)
$pathSocLib = DOL_DOCUMENT_ROOT.'/societe/lib/societe.lib.php';
$pathCmpLib = DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';

if (file_exists($pathSocLib)) {
    require_once $pathSocLib;                 // define societe_prepare_head()
} elseif (file_exists($pathCmpLib)) {
    require_once $pathCmpLib;                 // define societe_prepare_head() en algunas versiones
} else {
    // Mensaje claro si ninguna existe
    print 'No se encontró societe.lib.php ni company.lib.php en: '.DOL_DOCUMENT_ROOT;
    exit;
}

// (opcional, pero recomendable)
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
$langs->load('companies'); // textos de terceros

require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/custom/calificacioncrediticia/class/cc.lib.php';

$id = GETPOST('id','int');
if (!$id) accessforbidden();

$soc = new Societe($db);
$soc->fetch($id);

CCService::computeForSoc($db, $id, $conf);

$sql = "SELECT cc_score, cc_category, cc_veto_reason, cc_dso, cc_cash_ratio, cc_overdue_ratio, cc_updated_at
        FROM ".MAIN_DB_PREFIX."societe_extrafields WHERE fk_object=".(int)$id;
$res = $db->query($sql);
$e = $db->fetch_object($res);

llxHeader('', 'Nivel de Riesgo');
$head = societe_prepare_head($soc);
dol_fiche_head($head, 'calificacioncrediticia', $soc->name, -1, 'company');

$cat = $e ? $e->cc_category : '';
$score = $e ? round($e->cc_score,2) : 0;
$veto = $e ? $e->cc_veto_reason : '';
$dso = $e ? round($e->cc_dso,1) : 0;
$cash = $e ? round($e->cc_cash_ratio*100,1) : 0;
$ovr = $e ? round($e->cc_overdue_ratio*100,1) : 0;
$updated = $e ? $e->cc_updated_at : '';

$color = '#5cb85c';
if ($cat=='Estandar') $color = '#5bc0de';
if ($cat=='EnAtencion') $color = '#f0ad4e';
if ($cat=='AltoRiesgo') $color = '#d9534f';

print '<div style="display:flex;gap:12px;align-items:center;">';
print '<div style="padding:10px 16px;border-radius:8px;background:'.$color.';color:white;font-size:20px;font-weight:bold;">'.$cat.'</div>';
print '<div><div style="font-size:26px;font-weight:bold;">Score: '.$score.'</div><div>Actualizado: '.$updated.'</div></div>';
if ($veto) print '<div style="margin-left:auto;color:#d9534f;font-weight:bold;">Veto: '.$veto.'</div>';
print '</div><br>';

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre"><td>Métrica</td><td>Valor</td></tr>';
printf('<tr class="oddeven"><td>DSO</td><td>%s días</td></tr>', $dso);
printf('<tr class="oddeven"><td>%% Contado</td><td>%s%%</td></tr>', $cash);
printf('<tr class="oddeven"><td>%% Vencido / cartera</td><td>%s%%</td></tr>', $ovr);
print '</table>';

print '<br><a class="butAction" href="'.$_SERVER["PHP_SELF"].'?id='.$id.'&recalc=1">Recalcular</a>';

dol_fiche_end();
llxFooter(); $db->close();
