(function () {
  function getThirdpartyId() {
    try {
      var p = new URLSearchParams(location.search);
      var v = p.get('socid') || p.get('id');
      return parseInt(v || '0', 10) || 0;
    } catch (e) { return 0; }
  }

  function getRootCandidates() {
    // root1: antes de /comm/
    var path = location.pathname;              // ej: /sistema/comm/card.php  ó  /sistema/htdocs/comm/card.php
    var i = path.indexOf('/comm/');
    var root1 = i > 0 ? path.substring(0, i) : '';
    // root2: root1 + /htdocs (en tu instalación el endpoint vive aquí)
    var root2 = root1 ? (root1 + '/htdocs') : '/htdocs';
    return [root1, root2];
  }

  function mapCategory(cat) {
    if (!cat) return { label:'Sin categoría', cls:'cc-badge-neutral' };
    var k=(''+cat).toLowerCase();
    if (k==='premium')                return {label:'Premium',     cls:'cc-badge-premium'};
    if (k==='estandar')               return {label:'Estandar',    cls:'cc-badge-estandar'};
    if (k==='enatencion'||k==='en_atencion')
                                      return {label:'En atención', cls:'cc-badge-atencion'};
    if (k==='altoriesgo'||k==='alto_riesgo')
                                      return {label:'Alto riesgo', cls:'cc-badge-riesgo'};
    return {label:cat, cls:'cc-badge-neutral'};
  }

  // ====== NUEVO: localizar el badge "Activo" en cabecera ======
  function findStatusBadge() {
    // 1) Contenedor típico
    var el = document.querySelector('.statusref .badge');
    if (el) return el;
    // 2) Variantes de color nativas (verde, azul, rojo...)
    el = document.querySelector('.badge.badge-status4, .badge.badge-status3, .badge.badge-status8, .badge.badge-status1, .badge.badge-status6');
    if (el) return el;
    // 3) Fallback en cabecera
    var cand = document.querySelectorAll('.fichecenter .badge, .fichead .badge, .tabBar .badge');
    return cand.length ? cand[0] : null;
  }

// Quita cualquier clase de color del tema (badge-status0..9) y anula bordes/sombras
function stripDolBadgeClasses(el) {
  if (!el) return;
  for (var i = 0; i <= 9; i++) el.classList.remove('badge-status' + i);
  el.style.border = 'none';
  el.style.boxShadow = 'none';
  el.style.backgroundImage = 'none';
}

// Construye el badge SIN badge-statusX y con color propio
function buildInlineBadge(cat, score) {
  var info = mapCategory(cat);

  var pill = document.createElement('span');
  // Solo 'badge' + clases propias; NADA de badge-statusX
  pill.className = 'badge cc-risk-inline ' + info.cls;
  pill.textContent = info.label;

  // Colores inline (a prueba de tema)
  switch (info.cls) {
    case 'cc-badge-premium':
      pill.style.backgroundColor = '#4CAF50'; pill.style.color = '#ffffff'; break;
    case 'cc-badge-estandar':
      pill.style.backgroundColor = '#2196F3'; pill.style.color = '#ffffff'; break;
    case 'cc-badge-atencion':
      pill.style.backgroundColor = '#FF9800'; pill.style.color = '#ffffff'; break;
    case 'cc-badge-riesgo':
      pill.style.backgroundColor = '#F44336'; pill.style.color = '#ffffff'; break;
    default:
      pill.style.backgroundColor = '#9E9E9E'; pill.style.color = '#ffffff';
  }

  // Por si el navegador o el tema inyectan algo, limpiamos
  stripDolBadgeClasses(pill);

  if (typeof score === 'number') {
    var wrap = document.createElement('span');
    wrap.className = 'cc-risk-wrap';
    wrap.appendChild(pill);

    var sp = document.createElement('span');
    sp.className = 'cc-badge-score';
    sp.textContent = ' (Score: ' + (Math.round(score * 100) / 100) + ')';
    wrap.appendChild(sp);
    return wrap;
  }

  return pill;
}

// Inserta justo a la derecha del badge "Activo" y vuelve a limpiar por si acaso
function placeNextToStatus(cat, score) {
  var anchor = findStatusBadge();
  if (!anchor) return;
  var badge = buildInlineBadge(cat, score);
  anchor.insertAdjacentElement('afterend', badge);

  // si usamos wrapper con score, el badge real es el primer hijo
  var pill = badge.querySelector ? badge.querySelector('.cc-risk-inline') : badge;
  stripDolBadgeClasses(pill);
}


  // Mantengo el fetch con fallback: /sistema → /sistema/htdocs
  function fetchWithFallback(urls, opts) {
    return urls.reduce(
      (p, url) =>
        p.catch(() =>
          fetch(url, opts).then(r => {
            if (!r.ok) { const e = new Error('http '+r.status); e.status=r.status; throw e; }
            return r.json();
          })
        ),
      Promise.reject()
    );
  }

  function run(){
    var socid = getThirdpartyId(); if (!socid) return;
    var roots = getRootCandidates(); // p.ej. ['/sistema', '/sistema/htdocs']
    var urls  = roots.map(r => (r||'') + '/custom/calificacioncrediticia/ajax/cc_info.php?socid=' + socid);

    fetchWithFallback(urls, { credentials:'same-origin' })
      .then(function(data){
        if (data && !data.error) placeNextToStatus(data.cc_category, data.cc_score);
      })
      .catch(function(){ /* silencioso */ });
  }

  if (document.readyState==='loading') document.addEventListener('DOMContentLoaded', run);
  else run();
})();
