<?php
require_once DOL_DOCUMENT_ROOT.'/societe/class/societe.class.php';
require_once DOL_DOCUMENT_ROOT.'/custom/calificacioncrediticia/class/cc.lib.php';

class InterfaceCalificacionCrediticia
{
    public $family = 'calificacioncrediticia';
    public $description = 'Recalcular calificación CC';
    public $version = '1.0';

    function runTrigger($action, $object, $user, $langs, $conf)
    {
        global $db;
        $socid = 0;

        if (in_array($action, array('BILL_VALIDATE','BILL_CANCEL'))) $socid = $object->socid;
        if (in_array($action, array('PAYMENT_CUSTOMER_VALIDATE','PAYMENT_CUSTOMER_DELETE'))) $socid = $object->socid ?: ($object->fk_soc ?? 0);
        if (!$socid && isset($object->thirdparty) && is_object($object->thirdparty)) $socid = $object->thirdparty->id;

        if ($socid > 0) {
            try { CCService::computeForSoc($db, $socid, $conf); } catch (Exception $e) { dol_syslog('CC trigger error: '.$e->getMessage(), LOG_ERR); }
        }
        return 0;
    }
}
