<?php
/**
 * Widget de Inicio: Resumen de clientes por categoría (Calificación Crediticia)
 * Colocar en: /custom/calificacioncrediticia/core/boxes/box_cc_summary.php
 */
if (!defined('DOL_DOCUMENT_ROOT')) die('Must be included by Dolibarr');

require_once DOL_DOCUMENT_ROOT.'/core/boxes/modules_boxes.php';

class box_cc_summary extends ModeleBoxes
{
    public $boxcode  = 'box_cc_summary';
    public $boximg   = 'object_company';
    public $boxlabel = 'Resumen de riesgo (clientes)';
    public $depends  = array('calificacioncrediticia'); // el módulo debe estar activo

    /** @var DoliDB */
    public $db;

    // ¡IMPORTANTE!: inicializar como arrays para evitar count(null)
    public $info_box_head = array();
    public $info_box_contents = array();

    public function __construct($db, $param = '')
    {
        global $langs;
        $this->db = $db;

        $langs->load("boxes");
        $this->info_box_head = array(
            'text'   => '<strong>RESUMEN DE CLIENTES POR NIVEL DE RIESGO</strong>',
            'sublink'=> '',
            'subtext'=> '',
            'target' => '',
            'picto'  => $this->boximg
        );
    }

public function loadBox($max = 5)
{
    global $conf, $user, $langs;

    $this->info_box_contents = array();

    if (empty($user->rights->societe->lire)) {
        $this->info_box_contents[0][0] = array(
            'td'=>'class="center"',
            'text'=>$langs->trans('NotAllowed')
        );
        return;
    }

    $entity = (int) $conf->entity;
    $sql = "SELECT se.cc_category, COUNT(*) as total
            FROM ".MAIN_DB_PREFIX."societe_extrafields se
            INNER JOIN ".MAIN_DB_PREFIX."societe s ON s.rowid = se.fk_object
            WHERE s.client IN (1,2,3) AND s.entity = ".$entity."
            GROUP BY se.cc_category";

    $res = $this->db->query($sql);
    $rows = array('Premium'=>0,'Estandar'=>0,'EnAtencion'=>0,'AltoRiesgo'=>0,'Sin categoría'=>0);

    if ($res) {
        while ($o = $this->db->fetch_object($res)) {
            $k = (string)$o->cc_category;
            if ($k==='') $k='Sin categoría';
            if (!isset($rows[$k])) $rows[$k]=0;
            $rows[$k] += (int)$o->total;
        }
    }

    $cells = array(
        array('label'=>'Premium',    'class'=>'cc-badge-premium'),
        array('label'=>'Estandar',   'class'=>'cc-badge-estandar'),
        array('label'=>'EnAtencion', 'class'=>'cc-badge-atencion'),
        array('label'=>'AltoRiesgo', 'class'=>'cc-badge-riesgo'),
    );

    // ahora organizamos en 2 filas x 2 columnas
    $r = 0; $c = 0;
    foreach ($cells as $cell) {
        $label = $cell['label'];
        $val   = isset($rows[$label]) ? (int)$rows[$label] : 0;

        $html  = '<div class="boxstats" style="min-width:160px;margin:8px;">';
        $html .= '  <span class="boxstatstext">'.$label.'</span>';
        $html .= '  <div class="boxstatsindicator thumbstat nobold nounderline">';
        $html .= '    <span class="amount '.$cell['class'].'" style="padding:2px 12px;border-radius:10px;color:#fff;">'.$val.'</span>';
        $html .= '  </div>';
        $html .= '</div>';

        $this->info_box_contents[$r][$c] = array('td'=>'class="center"','text'=>$html);

        $c++;
        if ($c >= 2) { $c = 0; $r++; }  // cambia de fila cada 2 columnas
    }
}

    public function showBox($head = null, $contents = null, $nooutput = 0)
    {
        // Fallbacks para evitar count(null) en el padre
        if ($head === null) {
            $head = $this->info_box_head;
        }
        if (!is_array($contents)) {
            $contents = $this->info_box_contents;
        }
        return parent::showBox($head, $contents, $nooutput);
    }
}
