<?php
/**
 * actions_calificacioncrediticia.class.php — multi list integration (facturas + terceros)
 * --------------------------------------------------------------------------------------
 * - Añade "Clasif. crédito" + filtro en:
 *     * Facturas a clientes → context: invoicelist
 *     * Listado de terceros → context: thirdpartylist / thirdpartieslist
 * - Respeta el selector de columnas ($arrayfields['cc.cc_category']).
 */
class ActionsCalificacioncrediticia
{
    public $results = array();
    public $resprints;

    private $arrayfield_key = 'cc.cc_category';

    private function columnLabel() {
        global $langs;
        return $langs->trans("Clasif. crédito");
    }

    private function inAnyTargetList($parameters) {
        $ctx = '';
        if (!empty($parameters['currentcontext'])) $ctx = $parameters['currentcontext'];
        if (empty($ctx) && !empty($parameters['context'])) $ctx = $parameters['context'];
        return (strpos($ctx, 'invoicelist') !== false
             || strpos($ctx, 'thirdpartylist') !== false
             || strpos($ctx, 'thirdpartieslist') !== false);
    }

    public function formObjectOptions($parameters, &$object, &$action, $hookmanager)
    {
        $context = isset($parameters['currentcontext']) ? $parameters['currentcontext'] : '';
        if (strpos($context, 'thirdpartycard') === false) return 0;
        print '<script>window.DOL_URL_ROOT = '.json_encode(DOL_URL_ROOT).';</script>';
        return 0;
    }

    public function printFieldListSelect($parameters, &$object, &$action, $hookmanager)
    {
        if (!$this->inAnyTargetList($parameters)) return 0;

        $arrayfields = isset($parameters['arrayfields']) && is_array($parameters['arrayfields'])
            ? $parameters['arrayfields'] : array();
        $show = isset($arrayfields[$this->arrayfield_key]) ? !empty($arrayfields[$this->arrayfield_key]['checked']) : true;
        if (!$show) return 0;

        $prefix = defined('MAIN_DB_PREFIX') ? MAIN_DB_PREFIX : 'llx_';
        $useMinAggregate = false; // TRUE si ONLY_FULL_GROUP_BY estricto

        if ($useMinAggregate) {
            $sql =
                ", (SELECT MIN(se.cc_category) FROM ".$prefix."societe_extrafields se WHERE se.fk_object = s.rowid) AS cc_category"
              . ", (SELECT MIN(se.cc_score)    FROM ".$prefix."societe_extrafields se WHERE se.fk_object = s.rowid) AS cc_score";
        } else {
            $sql =
                ", (SELECT se.cc_category FROM ".$prefix."societe_extrafields se WHERE se.fk_object = s.rowid) AS cc_category"
              . ", (SELECT se.cc_score    FROM ".$prefix."societe_extrafields se WHERE se.fk_object = s.rowid) AS cc_score";
        }

        $this->resprints = $sql;
        return 1;
    }

    public function printFieldListWhere($parameters, &$object, &$action, $hookmanager)
    {
        if (!$this->inAnyTargetList($parameters)) return 0;

        global $db;
        $val = trim(GETPOST('search_cc_category', 'alpha'));
        if ($val !== '') {
            $prefix = defined('MAIN_DB_PREFIX') ? MAIN_DB_PREFIX : 'llx_';
            $this->resprints =
                " AND EXISTS (SELECT 1 FROM ".$prefix."societe_extrafields se"
              . "              WHERE se.fk_object = s.rowid"
              . "                AND se.cc_category = '".$db->escape($val)."')";
            return 1;
        }
        return 0;
    }

    public function printFieldListTitle($parameters, &$object, &$action, $hookmanager)
    {
        if (!$this->inAnyTargetList($parameters)) return 0;

        $arrayfields = isset($parameters['arrayfields']) && is_array($parameters['arrayfields'])
            ? $parameters['arrayfields'] : array();
        $show = isset($arrayfields[$this->arrayfield_key]) ? !empty($arrayfields[$this->arrayfield_key]['checked']) : true;
        if (!$show) return 0;

        print '<td class="liste_titre">'.$this->columnLabel().'</td>';
        return 1;
    }

    public function printFieldListOption($parameters, &$object, &$action, $hookmanager)
    {
        if (!$this->inAnyTargetList($parameters)) return 0;

        $arrayfields = isset($parameters['arrayfields']) && is_array($parameters['arrayfields'])
            ? $parameters['arrayfields'] : array();
        $show = isset($arrayfields[$this->arrayfield_key]) ? !empty($arrayfields[$this->arrayfield_key]['checked']) : true;
        if (!$show) return 0;

        $actual = GETPOST('search_cc_category', 'alpha');
        $opts = array('', 'Premium', 'Estandar', 'EnAtencion', 'AltoRiesgo');

        print '<td class="liste_titre">';
        print '<select class="flat" name="search_cc_category">';
        foreach ($opts as $o) {
            $sel = ($o === $actual) ? ' selected' : '';
            $label = $o === '' ? '' : $o;
            print '<option value="'.dol_escape_htmltag($o).'"'.$sel.'>'.$label.'</option>';
        }
        print '</select>';
        print '</td>';

        return 1;
    }

    public function printFieldListValue($parameters, &$object, &$action, $hookmanager)
    {
        if (!$this->inAnyTargetList($parameters)) return 0;

        $arrayfields = isset($parameters['arrayfields']) && is_array($parameters['arrayfields'])
            ? $parameters['arrayfields'] : array();
        $show = isset($arrayfields[$this->arrayfield_key]) ? !empty($arrayfields[$this->arrayfield_key]['checked']) : true;
        if (!$show) return 0;

        if (!empty($parameters['obj'])) {
            $obj = $parameters['obj'];
            $cat = isset($obj->cc_category) ? $obj->cc_category : '';
            print '<td class="nowrap">'.dol_escape_htmltag($cat).'</td>';
            return 1;
        }
        return 0;
    }
}
