<?php
// File: htdocs/custom/calificacioncrediticia/admin/setup.php
require '../../../main.inc.php';                                  // 3 niveles en tu XAMPP
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';         // << NECESARIO para dolibarr_set_const
if (!$user->admin) accessforbidden();

$langs->load("admin");

// Acción
$action = GETPOST('action', 'aZ09');

if ($action === 'save') {
    $consts = array(
        'CC_W_DSO','CC_W_CASH','CC_W_OVERDUE','CC_W_MARGIN','CC_W_SALES','CC_W_TENURE','CC_W_RETURNS','CC_W_EVENTS',
        'CC_THR_PREMIUM','CC_THR_ESTANDAR','CC_THR_ENATENCION',
        'CC_VETO_MAXOVERDUEDAYS','CC_VETO_BOUNCED_365','CC_VETO_BOUNCED_180',
        'CC_AUTO_RENORM','CC_EVENTS_MODE','CC_EVENTS_LABELS'
    );
    foreach ($consts as $k) {
        $val = GETPOST($k, 'restricthtml');                       // recoge texto tal cual
        // Guarda como constante global de la entidad actual
        dolibarr_set_const($db, $k, $val, 'chaine', 1, '', $conf->entity);
    }
    setEventMessages('Parámetros guardados', null, 'mesgs');
}

// UI
llxHeader('', 'Calificación Crediticia - Setup');
print load_fiche_titre('Calificación Crediticia - Parámetros', '', 'title_setup');

print '<form method="POST">';
print '<input type="hidden" name="token" value="'.newToken().'">'; // CSRF
print '<input type="hidden" name="action" value="save">';

print '<table class="noborder" width="100%">';
print '<tr class="liste_titre"><td>Clave</td><td>Valor</td></tr>';

$defs = array(
 'CC_W_DSO'=>'0.25','CC_W_CASH'=>'0.20','CC_W_OVERDUE'=>'0.15','CC_W_MARGIN'=>'0.00','CC_W_SALES'=>'0.05','CC_W_TENURE'=>'0.10','CC_W_RETURNS'=>'0.05','CC_W_EVENTS'=>'0.00',
 'CC_THR_PREMIUM'=>'85','CC_THR_ESTANDAR'=>'70','CC_THR_ENATENCION'=>'55',
 'CC_VETO_MAXOVERDUEDAYS'=>'45','CC_VETO_BOUNCED_365'=>'2','CC_VETO_BOUNCED_180'=>'1',
 'CC_AUTO_RENORM'=>'1','CC_EVENTS_MODE'=>'MANUAL','CC_EVENTS_LABELS'=>'DEVUELTO,RECHAZADO'
);

foreach ($defs as $k => $default) {
    $v = isset($conf->global->$k) ? $conf->global->$k : $default;
    print '<tr class="oddeven"><td>'.$k.'</td><td><input type="text" name="'.$k.'" size="60" value="'.dol_escape_htmltag($v).'"></td></tr>';
}
print '</table><br>';
print '<input class="button" type="submit" value="Guardar">';
print '</form>';

llxFooter(); $db->close();
