<?php

// Conexión a la base de datos
$host = 'localhost';
$db = 'aliment5_doli2';
$usuario = 'aliment5_root';
$pass = 'pluton007$';

$conn = new mysqli($host, $usuario, $pass, $db);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Inicializar variables
$mensaje = '';
$resultado = null; // Inicializamos la variable $resultado

// Manejo de operaciones CRUD
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create'])) {
        // Crear registro
        $fecha_solicitud = $_POST['fecha_solicitud'];
        $cliente = $_POST['cliente'];
        $rif_ci = $_POST['rif_ci'];
        $monto_transferido = $_POST['monto_transferido'];
        $banco_transferencia = $_POST['banco_transferencia'];
        $fecha_transferencia = $_POST['fecha_transferencia'];
        $referencia_transferencia = $_POST['referencia_transferencia'];
        $monto_reintegrado = $_POST['monto_reintegrado'];
        $banco_reintegro = $_POST['banco_reintegro'];
        $fecha_reintegro = $_POST['fecha_reintegro'];
        $referencia_reintegro = $_POST['referencia_reintegro'];

        // Verificar si ya existe un registro con el mismo cliente y referencia
        $stmt = $conn->prepare("SELECT COUNT(*) FROM reintegros_riga WHERE cliente = ? AND referencia_transferencia = ?");
        $stmt->bind_param("ss", $cliente, $referencia_transferencia);
        $stmt->execute();
        $stmt->bind_result($count);
        $stmt->fetch();
        $stmt->close();

        if ($count > 0) {
            $mensaje = "El registro ya existe.";
        } else {
            $stmt = $conn->prepare("INSERT INTO reintegros_riga (fecha_solicitud, cliente, rif_ci, monto_transferido, banco_transferencia, fecha_transferencia, referencia_transferencia, monto_reintegrado, banco_reintegro, fecha_reintegro, referencia_reintegro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssssssss", $fecha_solicitud, $cliente, $rif_ci, $monto_transferido, $banco_transferencia, $fecha_transferencia, $referencia_transferencia, $monto_reintegrado, $banco_reintegro, $fecha_reintegro, $referencia_reintegro);
            if ($stmt->execute()) {
                $mensaje = "Registro creado exitosamente.";
            } else {
                $mensaje = "Error al crear el registro: " . $stmt->error;
            }
            $stmt->close();
        }
    } elseif (isset($_POST['update'])) {
        // Actualizar registro
        $id = $_POST['id'];
        $fecha_solicitud = $_POST['fecha_solicitud'];
        $cliente = $_POST['cliente'];
        $rif_ci = $_POST['rif_ci'];
        $monto_transferido = $_POST['monto_transferido'];
        $banco_transferencia = $_POST['banco_transferencia'];
        $fecha_transferencia = $_POST['fecha_transferencia'];
        $referencia_transferencia = $_POST['referencia_transferencia'];
        $monto_reintegrado = $_POST['monto_reintegrado'];
        $banco_reintegro = $_POST['banco_reintegro'];
        $fecha_reintegro = $_POST['fecha_reintegro'];
        $referencia_reintegro = $_POST['referencia_reintegro'];

        $stmt = $conn->prepare("UPDATE reintegros_riga SET fecha_solicitud=?, cliente=?, rif_ci=?, monto_transferido=?, banco_transferencia=?, fecha_transferencia=?, referencia_transferencia=?, monto_reintegrado=?, banco_reintegro=?, fecha_reintegro=?, referencia_reintegro=? WHERE id=?");
        $stmt->bind_param("sssssssssssi", $fecha_solicitud, $cliente, $rif_ci, $monto_transferido, $banco_transferencia, $fecha_transferencia, $referencia_transferencia, $monto_reintegrado, $banco_reintegro, $fecha_reintegro, $referencia_reintegro, $id);
        if ($stmt->execute()) {
            $mensaje = "Registro actualizado exitosamente.";
        } else {
            $mensaje = "Error al actualizar el registro: " . $stmt->error;
        }
        $stmt->close();
    } elseif (isset($_POST['delete'])) {
        // Eliminar registro
        $id = $_POST['id'];
        $stmt = $conn->prepare("DELETE FROM reintegros_riga WHERE id=?");
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $mensaje = "Registro eliminado exitosamente.";
        } else {
            $mensaje = "Error al eliminar el registro: " . $stmt->error;
        }
        $stmt->close();
    }
}

// Filtrar registros
$filtro = '';
if (isset($_GET['filtro'])) {
    $filtro = $_GET['filtro'];
}

$sql = "SELECT * FROM reintegros_riga WHERE cliente LIKE ? OR referencia_transferencia LIKE ? OR referencia_reintegro LIKE ? ORDER BY id DESC";
$stmt = $conn->prepare($sql);
$filterParam = "%$filtro%";
$stmt->bind_param("sss", $filterParam, $filterParam, $filterParam);
$stmt->execute();
$stmt->store_result(); // Almacena el resultado
$stmt->bind_result($id, $fecha_solicitud, $cliente, $rif_ci, $monto_transferido, $banco_transferencia, $fecha_transferencia, $referencia_transferencia, $monto_reintegrado, $banco_reintegro, $fecha_reintegro, $referencia_reintegro);

$resultado = [];
while ($stmt->fetch()) {
    $resultado[] = [
        'id' => $id,
        'fecha_solicitud' => $fecha_solicitud,
        'cliente' => $cliente,
        'rif_ci' => $rif_ci,
        'monto_transferido' => $monto_transferido,
        'banco_transferencia' => $banco_transferencia,
        'fecha_transferencia' => $fecha_transferencia,
        'referencia_transferencia' => $referencia_transferencia,
        'monto_reintegrado' => $monto_reintegrado,
        'banco_reintegro' => $banco_reintegro,
        'fecha_reintegro' => $fecha_reintegro,
        'referencia_reintegro' => $referencia_reintegro,
    ];
}
$stmt->close(); // Cerrar la declaración


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <title>CRUD Reintegros</title>
    <style>
        body {
            background-color: #f8f9fa; /* Color de fondo */
        }
        .header {
            display: flex;
            align-items: center; /* Centrar verticalmente */
            background-color: #007bff; /* Fondo azul */
            color: white; /* Texto blanco */
            padding: 15px; /* Espaciado interno */
            border-radius: 10px; /* Bordes redondeados */
            margin-bottom: 20px; /* Espacio inferior */
        }
        .header img {
            width: 200px; /* Ancho del logotipo */
            height: auto; /* Mantener proporciones */
            margin-right: 15px; /* Espacio entre el logo y el título */
        }
        .card {
            background-color: #ffffff; /* Fondo blanco para la tarjeta */
            border-radius: 10px; /* Bordes redondeados */
            padding: 20px; /* Espaciado interno */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); /* Sombra suave */
        }
        .form-control {
            border-radius: 5px; /* Bordes redondeados en los campos */
        }
        .btn {
            border-radius: 5px; /* Bordes redondeados en los botones */
        }
        .table {
            margin-top: 20px; /* Espacio superior para la tabla */
            border-radius: 10px; /* Bordes redondeados en la tabla */
            overflow: hidden; /* Para que los bordes redondeados se vean */
        }
        .table th, .table td {
            vertical-align: middle; /* Centrar contenido verticalmente */
        }
        .alert {
            margin-top: 20px; /* Espacio superior para el mensaje */
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="header">
        <img src="img/logo.png" alt="Logotipo">
        <h2 class="m-0">Gestión de Reintegros Bancarios</h2>
    </div>

    <?php if ($mensaje): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($mensaje); ?></div>
    <?php endif; ?>

    <form method="GET" class="mb-4">
        <div class="form-row">
            <div class="col-md-8">
                <input type="text" name="filtro" class="form-control" placeholder="Filtrar por cliente, referencia transferencia o referencia reintegro" value="<?php echo htmlspecialchars($filtro); ?>">
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary btn-block">Filtrar</button>
                <a href="reintegro.php" class="btn btn-secondary btn-block">Quitar Filtro</a>
                 <a href="https://www.alimentosriga.com/sistema/htdocs/compta/bank/list.php?mainmenu=bank&leftmenu=" class="btn btn-primary btn-block">Regresar</a>
            </div>
        </div>
    </form>

    <div class="row">
    <?php if ($resultado): foreach ($resultado as $fila): ?>
        <div class="col-md-4 mb-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Reintegro ID: <?php echo htmlspecialchars($fila['id']); ?></h5>
                    <p><strong>Fecha Solicitud:</strong> <?php echo htmlspecialchars($fila['fecha_solicitud']); ?></p>
                    <p><strong>Cliente:</strong> <?php echo htmlspecialchars($fila['cliente']); ?></p>
                    <p><strong>RIF/CI:</strong> <?php echo htmlspecialchars($fila['rif_ci']); ?></p>
                    <p><strong>Monto Transferido:</strong> <?php echo htmlspecialchars($fila['monto_transferido']); ?></p>
                    <p><strong>Banco Transferencia:</strong> <?php echo htmlspecialchars($fila['banco_transferencia']); ?></p>
                    <p><strong>Fecha Transferencia:</strong> <?php echo htmlspecialchars($fila['fecha_transferencia']); ?></p>
                    <p><strong>Referencia Transferencia:</strong> <?php echo htmlspecialchars($fila['referencia_transferencia']); ?></p>
                    <p><strong>Monto Reintegrado:</strong> <?php echo htmlspecialchars($fila['monto_reintegrado']); ?></p>
                    <p><strong>Banco Reintegro:</strong> <?php echo htmlspecialchars($fila['banco_reintegro']); ?></p>
                    <p><strong>Fecha Reintegro:</strong> <?php echo htmlspecialchars($fila['fecha_reintegro']); ?></p>
                    <p><strong>Referencia Reintegro:</strong> <?php echo htmlspecialchars($fila['referencia_reintegro']); ?></p>
                    <form method="POST" class="modify-form">
                        <input type="hidden" name="id" value="<?php echo $fila['id']; ?>">
                        <!-- Campos ocultos para la edición -->
                        <button type="button" class="btn btn-info" onclick="enableFields(this)">Modificar</button>
                        <button type="submit" name="update" class="btn btn-warning" style="display:none;">Actualizar</button>
                        <button type="submit" name="delete" class="btn btn-danger">Eliminar</button>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; endif; ?>
</div>


    <h3 class="text-center">Agregar Nuevo Reintegro</h3>
<div class="card mb-4">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="id">
            <div class="form-row">
                <div class="col-md-6 mb-3">
                    <label for="fecha_solicitud">Fecha Solicitud</label>
                    <input type="date" name="fecha_solicitud" class="form-control" placeholder="Fecha Solicitud" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="cliente">Cliente</label>
                    <input type="text" name="cliente" class="form-control" placeholder="Cliente" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="rif_ci">RIF/CI</label>
                    <input type="text" name="rif_ci" class="form-control" placeholder="RIF/CI" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="monto_transferido">Monto Transferido</label>
                    <input type="number" step="0.01" name="monto_transferido" class="form-control" placeholder="Monto Transferido" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="banco_transferencia">Banco Transferencia</label>
                    <input type="text" name="banco_transferencia" class="form-control" placeholder="Banco Transferencia" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="fecha_transferencia">Fecha Transferencia</label>
                    <input type="date" name="fecha_transferencia" class="form-control" placeholder="Fecha Transferencia" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="referencia_transferencia">Referencia Transferencia</label>
                    <input type="text" name="referencia_transferencia" class="form-control" placeholder="Referencia Transferencia" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="monto_reintegrado">Monto Reintegrado</label>
                    <input type="number" step="0.01" name="monto_reintegrado" class="form-control" placeholder="Monto Reintegrado" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="banco_reintegro">Banco Reintegro</label>
                    <input type="text" name="banco_reintegro" class="form-control" placeholder="Banco Reintegro" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="fecha_reintegro">Fecha Reintegro</label>
                    <input type="date" name="fecha_reintegro" class="form-control" placeholder="Fecha Reintegro" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="referencia_reintegro">Referencia Reintegro</label>
                    <input type="text" name="referencia_reintegro" class="form-control" placeholder="Referencia Reintegro" required>
                </div>
            </div>
            <button type="submit" name="create" class="btn btn-success btn-block">Agregar</button>
        </form>
    </div>
</div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script>
        function enableFields(button) {
            const form = button.closest('form');
            const inputs = form.querySelectorAll('input[type="hidden"]');
            inputs.forEach(input => {
                const inputField = document.createElement('input');
                inputField.type = 'text';
                inputField.name = input.name;
                inputField.value = input.value;
                inputField.className = 'form-control mb-2';
                form.insertBefore(inputField, button);
                input.remove(); // Eliminar el campo oculto
            });
            button.style.display = 'none'; // Ocultar botón de modificar
            form.querySelector('button[name="update"]').style.display = 'inline'; // Mostrar botón de actualización
        }
    </script>
</body>
</html>
